/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.artifacts.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.artifacts.model.ContainerRepositorySummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ContainerRepositoryCollection
extends ExplicitlySetBmcModel {
    @JsonProperty(value="layerCount")
    private final Integer layerCount;
    @JsonProperty(value="layersSizeInBytes")
    private final Long layersSizeInBytes;
    @JsonProperty(value="imageCount")
    private final Integer imageCount;
    @JsonProperty(value="items")
    private final List<ContainerRepositorySummary> items;
    @JsonProperty(value="remainingItemsCount")
    private final Integer remainingItemsCount;
    @JsonProperty(value="repositoryCount")
    private final Integer repositoryCount;

    @Deprecated
    @ConstructorProperties(value={"layerCount", "layersSizeInBytes", "imageCount", "items", "remainingItemsCount", "repositoryCount"})
    public ContainerRepositoryCollection(Integer layerCount, Long layersSizeInBytes, Integer imageCount, List<ContainerRepositorySummary> items, Integer remainingItemsCount, Integer repositoryCount) {
        this.layerCount = layerCount;
        this.layersSizeInBytes = layersSizeInBytes;
        this.imageCount = imageCount;
        this.items = items;
        this.remainingItemsCount = remainingItemsCount;
        this.repositoryCount = repositoryCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getLayerCount() {
        return this.layerCount;
    }

    public Long getLayersSizeInBytes() {
        return this.layersSizeInBytes;
    }

    public Integer getImageCount() {
        return this.imageCount;
    }

    public List<ContainerRepositorySummary> getItems() {
        return this.items;
    }

    public Integer getRemainingItemsCount() {
        return this.remainingItemsCount;
    }

    public Integer getRepositoryCount() {
        return this.repositoryCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ContainerRepositoryCollection(");
        sb.append("super=").append(super.toString());
        sb.append("layerCount=").append(String.valueOf(this.layerCount));
        sb.append(", layersSizeInBytes=").append(String.valueOf(this.layersSizeInBytes));
        sb.append(", imageCount=").append(String.valueOf(this.imageCount));
        sb.append(", items=").append(String.valueOf(this.items));
        sb.append(", remainingItemsCount=").append(String.valueOf(this.remainingItemsCount));
        sb.append(", repositoryCount=").append(String.valueOf(this.repositoryCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContainerRepositoryCollection)) {
            return false;
        }
        ContainerRepositoryCollection other = (ContainerRepositoryCollection)((Object)o);
        return Objects.equals(this.layerCount, other.layerCount) && Objects.equals(this.layersSizeInBytes, other.layersSizeInBytes) && Objects.equals(this.imageCount, other.imageCount) && Objects.equals(this.items, other.items) && Objects.equals(this.remainingItemsCount, other.remainingItemsCount) && Objects.equals(this.repositoryCount, other.repositoryCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.layerCount == null ? 43 : this.layerCount.hashCode());
        result = result * 59 + (this.layersSizeInBytes == null ? 43 : this.layersSizeInBytes.hashCode());
        result = result * 59 + (this.imageCount == null ? 43 : this.imageCount.hashCode());
        result = result * 59 + (this.items == null ? 43 : this.items.hashCode());
        result = result * 59 + (this.remainingItemsCount == null ? 43 : this.remainingItemsCount.hashCode());
        result = result * 59 + (this.repositoryCount == null ? 43 : this.repositoryCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="layerCount")
        private Integer layerCount;
        @JsonProperty(value="layersSizeInBytes")
        private Long layersSizeInBytes;
        @JsonProperty(value="imageCount")
        private Integer imageCount;
        @JsonProperty(value="items")
        private List<ContainerRepositorySummary> items;
        @JsonProperty(value="remainingItemsCount")
        private Integer remainingItemsCount;
        @JsonProperty(value="repositoryCount")
        private Integer repositoryCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder layerCount(Integer layerCount) {
            this.layerCount = layerCount;
            this.__explicitlySet__.add("layerCount");
            return this;
        }

        public Builder layersSizeInBytes(Long layersSizeInBytes) {
            this.layersSizeInBytes = layersSizeInBytes;
            this.__explicitlySet__.add("layersSizeInBytes");
            return this;
        }

        public Builder imageCount(Integer imageCount) {
            this.imageCount = imageCount;
            this.__explicitlySet__.add("imageCount");
            return this;
        }

        public Builder items(List<ContainerRepositorySummary> items) {
            this.items = items;
            this.__explicitlySet__.add("items");
            return this;
        }

        public Builder remainingItemsCount(Integer remainingItemsCount) {
            this.remainingItemsCount = remainingItemsCount;
            this.__explicitlySet__.add("remainingItemsCount");
            return this;
        }

        public Builder repositoryCount(Integer repositoryCount) {
            this.repositoryCount = repositoryCount;
            this.__explicitlySet__.add("repositoryCount");
            return this;
        }

        public ContainerRepositoryCollection build() {
            ContainerRepositoryCollection model = new ContainerRepositoryCollection(this.layerCount, this.layersSizeInBytes, this.imageCount, this.items, this.remainingItemsCount, this.repositoryCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ContainerRepositoryCollection model) {
            if (model.wasPropertyExplicitlySet("layerCount")) {
                this.layerCount(model.getLayerCount());
            }
            if (model.wasPropertyExplicitlySet("layersSizeInBytes")) {
                this.layersSizeInBytes(model.getLayersSizeInBytes());
            }
            if (model.wasPropertyExplicitlySet("imageCount")) {
                this.imageCount(model.getImageCount());
            }
            if (model.wasPropertyExplicitlySet("items")) {
                this.items(model.getItems());
            }
            if (model.wasPropertyExplicitlySet("remainingItemsCount")) {
                this.remainingItemsCount(model.getRemainingItemsCount());
            }
            if (model.wasPropertyExplicitlySet("repositoryCount")) {
                this.repositoryCount(model.getRepositoryCount());
            }
            return this;
        }
    }
}

