/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.issuetable;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.bugtracking.commons.UIUtils;
import org.netbeans.modules.bugtracking.issuetable.ColumnDescriptor;
import org.netbeans.modules.bugtracking.issuetable.Filter;
import org.netbeans.modules.bugtracking.issuetable.FindInQueryBar;
import org.netbeans.modules.bugtracking.issuetable.FindInQuerySupport;
import org.netbeans.modules.bugtracking.issuetable.IssueNode;
import org.netbeans.modules.bugtracking.issuetable.NodeTableModel;
import org.netbeans.modules.bugtracking.issuetable.QueryTableCellRenderer;
import org.netbeans.modules.bugtracking.issuetable.QueryTableHeaderRenderer;
import org.netbeans.modules.bugtracking.issuetable.SummaryTextFilter;
import org.netbeans.modules.bugtracking.issuetable.TableSorter;
import org.netbeans.modules.bugtracking.spi.BugtrackingSupport;
import org.netbeans.modules.bugtracking.spi.IssueStatusProvider;
import org.netbeans.modules.bugtracking.spi.QueryController;
import org.openide.awt.MouseUtils;
import org.openide.explorer.view.TreeTableView;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class IssueTable
implements MouseListener,
AncestorListener,
KeyListener,
PropertyChangeListener {
    static final Logger LOG = Logger.getLogger(IssueTable.class.getName());
    private NodeTableModel tableModel;
    private JTable table;
    private final JPanel component;
    private final TableSorter sorter;
    private ColumnDescriptor[] descriptors;
    private Filter allFilter;
    private Filter newOrChangedFilter;
    private Filter filter;
    private Filter[] filters;
    private Set<IssueNode> nodes = new HashSet<IssueNode>();
    private final QueryTableHeaderRenderer queryTableHeaderRenderer;
    private RequestProcessor.Task storeColumnsTask;
    private final StoreColumnsHandler storeColumnsWidthHandler;
    private final JButton colsButton;
    private boolean savedQueryInitialized;
    private SummaryTextFilter textFilter;
    private static final String CONFIG_DELIMITER = "<=>";
    private final FindInQuerySupport findInQuerySupport;
    private boolean isSaved;
    private static final Comparator<IssueNode.IssueProperty<Object>> nodeComparator = new Comparator<IssueNode.IssueProperty<Object>>(){

        @Override
        public int compare(IssueNode.IssueProperty<Object> p1, IssueNode.IssueProperty<Object> p2) {
            Integer sk1 = (Integer)p1.getValue("sortkey");
            if (sk1 != null) {
                Integer sk2 = (Integer)p2.getValue("sortkey");
                return sk2 != null ? sk1.compareTo(sk2) : 1;
            }
            try {
                return p1.compareTo(p2);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, null, e);
                return 0;
            }
        }
    };
    private RequestProcessor rp;
    private final String repositoryId;
    private final QueryTableCellRenderer cellRenderer;
    private final Map<Cell, Set<CellAction>> cellActions = new HashMap<Cell, Set<CellAction>>();
    private TableColumnModelListener tcml = new TableColumnModelListener(){

        @Override
        public void columnAdded(TableColumnModelEvent e) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            int to;
            int from = e.getFromIndex();
            if (from == (to = e.getToIndex())) {
                return;
            }
            IssueTable.this.table.getTableHeader().getColumnModel().getColumn(from).setModelIndex(from);
            IssueTable.this.table.getTableHeader().getColumnModel().getColumn(to).setModelIndex(to);
            IssueTable.this.tableModel.moveColumn(from, to);
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
            IssueTable.this.storeColumnsTask.schedule(1000);
        }
    };
    private static final String COLUMN_WIDTH_PREFIX = "bugtracking.issuetable.columnwidth";
    private static final String COLUMN_SORTING_PREFIX = "bugtracking.issuetable.columnsorting";

    public IssueTable(String repositoryId, String queryName, QueryController controller, ColumnDescriptor[] descriptors, boolean isSaved) {
        this(repositoryId, queryName, controller, descriptors, isSaved, 22, 31);
    }

    public IssueTable(String repositoryId, String queryName, QueryController controller, ColumnDescriptor[] descriptors, boolean isSaved, int vsbPolicy, int hsbPolicy) {
        assert (descriptors != null);
        assert (descriptors.length > 0);
        if (queryName == null) {
            queryName = "#find#issues#hitlist#table#";
        }
        this.repositoryId = repositoryId + ":" + queryName;
        controller.addPropertyChangeListener((PropertyChangeListener)this);
        this.descriptors = descriptors;
        this.component = new JPanel(){

            @Override
            public void requestFocus() {
                IssueTable.this.table.requestFocus();
            }
        };
        this.isSaved = isSaved;
        this.initFilters();
        this.tableModel = new NodeTableModel();
        this.sorter = new TableSorter(this.tableModel, this);
        this.sorter.setColumnComparator(Node.Property.class, nodeComparator);
        this.table = new JTable(this.sorter);
        this.sorter.setTableHeader(this.table.getTableHeader());
        this.table.setRowHeight(this.table.getRowHeight() * 6 / 5);
        JScrollPane tableScrollPane = new JScrollPane(this.table, vsbPolicy, hsbPolicy);
        tableScrollPane.getViewport().setBackground(this.table.getBackground());
        Color borderColor = UIManager.getColor("scrollpane_border");
        if (borderColor == null) {
            borderColor = UIManager.getColor("controlShadow");
        }
        tableScrollPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, borderColor));
        ImageIcon ic = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugtracking/commons/resources/columns_16.png", (boolean)true);
        this.colsButton = new JButton(ic);
        this.colsButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TreeTableView.class, (String)"ACN_ColumnsSelector"));
        this.colsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TreeTableView.class, (String)"ACD_ColumnsSelector"));
        this.colsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (IssueTable.this.tableModel.selectVisibleColumns()) {
                    IssueTable.this.setDefaultColumnSizes();
                    IssueTable.this.storeColumnsTask.schedule(1000);
                }
            }
        });
        tableScrollPane.setCorner("UPPER_RIGHT_CORNER", this.colsButton);
        this.findInQuerySupport = FindInQuerySupport.create(this);
        FindInQueryBar findBar = this.findInQuerySupport.getFindBar();
        this.initComponents(tableScrollPane, findBar);
        this.table.addMouseListener(this);
        this.table.addKeyListener(this);
        this.table.addAncestorListener(this.findInQuerySupport.getAncestorListener());
        this.cellRenderer = new QueryTableCellRenderer(this, isSaved);
        this.table.setDefaultRenderer(Node.Property.class, this.cellRenderer);
        this.queryTableHeaderRenderer = new QueryTableHeaderRenderer(this.table.getTableHeader().getDefaultRenderer(), this);
        this.queryTableHeaderRenderer.setSaved(isSaved);
        this.table.getTableHeader().setDefaultRenderer(this.queryTableHeaderRenderer);
        this.table.addAncestorListener(this);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IssueTable.class, (String)"ACSN_IssueTable"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssueTable.class, (String)"ACSD_IssueTable"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IssueTable.this.initColumns();
            }
        });
        this.table.getTableHeader().addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                IssueTable.this.table.getColumnModel().addColumnModelListener(IssueTable.this.tcml);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                IssueTable.this.table.getColumnModel().removeColumnModelListener(IssueTable.this.tcml);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        UIUtils.fixFocusTraversalKeys((JComponent)this.table);
        this.storeColumnsWidthHandler = new StoreColumnsHandler();
        this.storeColumnsTask = this.getRequestProcessor().create((Runnable)this.storeColumnsWidthHandler);
    }

    private void initComponents(JScrollPane tablePane, FindInQueryBar findBar) {
        GroupLayout layout = new GroupLayout(this.component);
        this.component.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(findBar, -1, -1, Short.MAX_VALUE).addComponent(tablePane, -1, 549, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(tablePane, -1, 379, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(findBar, -2, -1, -2)));
    }

    public Filter[] getDefinedFilters() {
        return this.filters;
    }

    public Filter getAllFilter() {
        return this.allFilter;
    }

    public Filter getNewOrChangedFilter() {
        return this.newOrChangedFilter;
    }

    public void resetFilterBySummary() {
        this.setFilterIntern(this.filter);
    }

    public void switchFilterBySummaryHighlight(boolean on) {
        assert (this.textFilter != null);
        if (this.textFilter == null) {
            return;
        }
        this.textFilter.setHighlighting(on);
        this.table.repaint();
    }

    public void setFilterBySummary(String searchText, boolean regular, boolean wholeWords, boolean matchCase) {
        if (this.textFilter == null) {
            this.textFilter = new SummaryTextFilter();
        }
        this.textFilter.setText(searchText, regular, wholeWords, matchCase);
        this.setFilterIntern(this.textFilter);
    }

    public void setRenderer(TableCellRenderer renderer) {
        this.table.setDefaultRenderer(Node.Property.class, renderer);
    }

    public TableCellRenderer getRenderer() {
        return this.table.getDefaultRenderer(Node.Property.class);
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
        this.setFilterIntern(filter);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("bugtracking.query.changed")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IssueTable.this.isSaved = true;
                    IssueTable.this.cellRenderer.setSaved(true);
                    IssueTable.this.queryTableHeaderRenderer.setSaved(true);
                    IssueTable.this.initColumns();
                }
            });
        }
    }

    public JComponent getComponent() {
        return this.component;
    }

    public final void initColumns() {
        if (this.savedQueryInitialized) {
            return;
        }
        this.setModelProperties();
        if (this.descriptors.length > 0) {
            Map<Integer, Integer> sorting = this.getColumnSorting();
            if (this.descriptors.length > 1) {
                for (int i = 0; i < this.descriptors.length; ++i) {
                    int visibleIdx = this.tableModel.getVisibleIndex(i);
                    Integer order = sorting.get(visibleIdx);
                    if (order != null) {
                        this.sorter.setSortingStatus(visibleIdx, order);
                        continue;
                    }
                    if (i == 0) {
                        this.sorter.setSortingStatus(0, 1);
                        continue;
                    }
                    this.sorter.setColumnComparator(i, null);
                    this.sorter.setSortingStatus(i, 0);
                }
            }
        }
        this.setDefaultColumnSizes();
        if (this.isSaved) {
            this.savedQueryInitialized = true;
        }
    }

    void sortOrderChanged() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.sorter.getColumnCount(); ++i) {
            if (i > 0) {
                sb.append(CONFIG_DELIMITER);
            }
            sb.append(i).append(CONFIG_DELIMITER).append(this.sorter.getSortingStatus(i));
        }
        this.storeColumnSorting(this.repositoryId, sb.toString());
    }

    private Map<Integer, Integer> getColumnSorting() {
        String sortingString = this.getColumnSorting(this.repositoryId);
        if (sortingString == null || sortingString.equals("")) {
            return Collections.emptyMap();
        }
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        String[] sortingArray = sortingString.split(CONFIG_DELIMITER);
        for (int i = 0; i < sortingArray.length; i += 2) {
            try {
                map.put(Integer.parseInt(sortingArray[i]), Integer.parseInt(sortingArray[i + 1]));
                continue;
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                LOG.log(Level.FINE, null, e);
            }
        }
        return map;
    }

    private void initFilters() {
        this.allFilter = Filter.getAllFilter();
        this.newOrChangedFilter = Filter.getNotSeenFilter();
        this.filters = new Filter[]{this.allFilter, this.newOrChangedFilter};
        this.filter = this.allFilter;
    }

    int getSeenColumnIdx() {
        return this.tableModel.getIndexForPropertyName("issue.seen");
    }

    int getRecentChangesColumnIdx() {
        return this.tableModel.getIndexForPropertyName("issue.recent_changes");
    }

    private void setFilterIntern(Filter filter) {
        final ArrayList<IssueNode> filteredNodes = new ArrayList<IssueNode>(this.nodes.size());
        for (IssueNode node : this.nodes) {
            if (filter != null && !filter.accept(node)) continue;
            filteredNodes.add(node);
        }
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ IssueTable this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.setTableModel(filteredNodes.toArray(new IssueNode[0]));
            }
        });
    }

    SummaryTextFilter getSummaryFilter() {
        return this.textFilter;
    }

    private RequestProcessor getRequestProcessor() {
        if (this.rp == null) {
            this.rp = new RequestProcessor("Issue table", 5);
        }
        return this.rp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCellAction(int row, int column, Rectangle bounds, ActionListener l) {
        Map<Cell, Set<CellAction>> map = this.cellActions;
        synchronized (map) {
            Cell cell = new Cell(row, column);
            Set<CellAction> actions = this.cellActions.get(cell);
            if (actions == null) {
                actions = new HashSet<CellAction>(1);
                this.cellActions.put(cell, actions);
            }
            actions.add(new CellAction(bounds, l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCellActions(int row, int column) {
        Cell cell = new Cell(row, column);
        Map<Cell, Set<CellAction>> map = this.cellActions;
        synchronized (map) {
            this.cellActions.remove(cell);
        }
    }

    void setDefaultColumnSizes() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                int[] widths = IssueTable.this.getColumnWidths(IssueTable.this.repositoryId);
                Map persistedColumnsMap = IssueTable.this.getPersistedColumnValues();
                if (persistedColumnsMap.size() > 0) {
                    TableColumnModel columnModel = IssueTable.this.table.getColumnModel();
                    int columnCount = columnModel.getColumnCount();
                    for (int i = 0; i < columnCount; ++i) {
                        String id = IssueTable.this.tableModel.getColumnId(i);
                        Integer w = (Integer)persistedColumnsMap.get(id);
                        if (w == null || w <= 0) continue;
                        this.setColumnWidth(i, w);
                    }
                } else if (widths != null && widths.length > 0) {
                    int columnCount = IssueTable.this.table.getColumnModel().getColumnCount();
                    for (int i = 0; i < widths.length && i < columnCount; ++i) {
                        int w = widths[i];
                        if (w <= 0) continue;
                        this.setColumnWidth(i, w);
                    }
                } else {
                    int idx;
                    ColumnDescriptor[] visibleDescriptors = IssueTable.this.getVisibleDescriptors();
                    for (int i = 0; i < visibleDescriptors.length; ++i) {
                        ColumnDescriptor desc = visibleDescriptors[i];
                        int w = desc.getWidth();
                        if (w > 0) {
                            this.setColumnWidth(i, w);
                            continue;
                        }
                        if (w != 0) continue;
                        this.setWidthForFit(i);
                    }
                    if (IssueTable.this.isSaved && (idx = IssueTable.this.getRecentChangesColumnIdx()) > -1) {
                        int w = UIUtils.getColumnWidthInPixels((int)25, (JComponent)IssueTable.this.table);
                        this.setColumnWidth(IssueTable.this.getRecentChangesColumnIdx(), w);
                    }
                }
                if (IssueTable.this.isSaved) {
                    int seenIdx = IssueTable.this.getSeenColumnIdx();
                    IssueTable.this.table.getColumnModel().getColumn(seenIdx).setMaxWidth(28);
                    IssueTable.this.table.getColumnModel().getColumn(seenIdx).setPreferredWidth(28);
                }
            }

            private void setColumnWidth(int i, int w) {
                IssueTable.this.table.getColumnModel().getColumn(i).setMinWidth(10);
                IssueTable.this.table.getColumnModel().getColumn(i).setMaxWidth(10000);
                IssueTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(w);
            }

            private void setWidthForFit(int i) {
                TableColumn c = IssueTable.this.table.getColumnModel().getColumn(i);
                Component comp = IssueTable.this.queryTableHeaderRenderer.getTableCellRendererComponent(IssueTable.this.table, c.getHeaderValue(), false, false, 0, i);
                if (comp instanceof JLabel) {
                    JLabel label = (JLabel)comp;
                    int w = label.getPreferredSize().width;
                    if (w > -1) {
                        this.setColumnWidth(i, w);
                    }
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private ColumnDescriptor[] getVisibleDescriptors() {
        LinkedList<ColumnDescriptor> visible = new LinkedList<ColumnDescriptor>();
        for (ColumnDescriptor d : this.descriptors) {
            if (!d.isVisible()) continue;
            visible.add(d);
        }
        return visible.toArray(new ColumnDescriptor[0]);
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.setDefaultColumnSizes();
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    private void setModelProperties() {
        Map<String, Integer> persistedColumnsMap;
        ArrayList<ColumnDescriptor> properties = new ArrayList<ColumnDescriptor>(this.descriptors.length + (this.isSaved ? 2 : 0));
        for (int i = 0; i < this.descriptors.length; ++i) {
            ColumnDescriptor desc = this.descriptors[i];
            properties.add(desc);
        }
        if (this.isSaved) {
            properties.add(new RecentChangesDescriptor());
            properties.add(new SeenDescriptor());
        }
        if ((persistedColumnsMap = this.getPersistedColumnValues()).size() > 0) {
            for (ColumnDescriptor cd : properties) {
                if (cd.getName().equals("issue.seen")) continue;
                cd.setVisible(persistedColumnsMap.containsKey(cd.getName()));
            }
        }
        this.descriptors = properties.toArray(new ColumnDescriptor[0]);
        this.tableModel.setProperties(this.descriptors);
    }

    private Map<String, Integer> getPersistedColumnValues() {
        String columns = this.getColumns(this.repositoryId);
        String[] visibleColumns = columns.split(CONFIG_DELIMITER);
        if (visibleColumns.length <= 1) {
            return Collections.emptyMap();
        }
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (int i = 0; i < visibleColumns.length; i += 2) {
            try {
                ret.put(visibleColumns[i], Integer.parseInt(visibleColumns[i + 1]));
                continue;
            }
            catch (NumberFormatException nfe) {
                ret.put(visibleColumns[i], -1);
                LOG.log(Level.WARNING, visibleColumns[i], nfe);
            }
        }
        return ret;
    }

    private void setTableModel(IssueNode[] nodes) {
        this.tableModel.setNodes((Node[])nodes);
    }

    void focus() {
        this.table.requestFocus();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void mouseClicked(MouseEvent e) {
        int row = this.table.rowAtPoint(e.getPoint());
        int column = this.table.columnAtPoint(e.getPoint());
        if (!SwingUtilities.isLeftMouseButton(e)) return;
        if (row == -1) {
            return;
        }
        row = this.sorter.modelIndex(row);
        if (!MouseUtils.isDoubleClick((MouseEvent)e)) {
            if (column == this.getSeenColumnIdx()) {
                final IssueNode in = (IssueNode)this.tableModel.getNodes()[row];
                this.getRequestProcessor().post(new Runnable(){
                    final /* synthetic */ IssueTable this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        IssueStatusProvider.Status status = in.getStatus();
                        in.setSeen(status != IssueStatusProvider.Status.SEEN);
                    }
                });
            }
            CellAction[] actions = null;
            CellAction[] cellActionArray = this.cellActions;
            synchronized (this.cellActions) {
                Cell cell = new Cell(row, column);
                Set<CellAction> set = this.cellActions.get(cell);
                if (set == null) return;
                CellAction[] cellActionArray2 = set.toArray(new CellAction[0]);
                actions = cellActionArray2;
                // ** MonitorExit[var5_6] (shouldn't be in output)
                if (actions == null) return;
                cellActionArray = actions;
                int n = cellActionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CellAction cellAction = cellActionArray[n2];
                    cellAction.actionPerformed(null);
                    ++n2;
                }
                return;
            }
        }
        Action action = this.tableModel.getNodes()[row].getPreferredAction();
        if (!action.isEnabled()) return;
        action.actionPerformed(new ActionEvent(this, 0, ""));
    }

    @Override
    public void keyTyped(KeyEvent e) {
        int row;
        if (e.getKeyChar() == '\n' && (row = this.table.getSelectedRow()) != -1) {
            row = this.sorter.modelIndex(row);
            Action action = this.tableModel.getNodes()[row].getPreferredAction();
            if (action.isEnabled()) {
                action.actionPerformed(new ActionEvent(this, 0, ""));
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int row;
        if (e.getKeyChar() == '\n' && (row = this.table.getSelectedRow()) != -1) {
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public void addNode(final IssueNode node) {
        this.nodes.add(node);
        if (this.filter == null || this.filter.accept(node)) {
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ IssueTable this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.tableModel.insertNode((Node)node);
                }
            });
        }
    }

    public void started() {
        this.nodes.clear();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IssueTable.this.setTableModel(new IssueNode[0]);
            }
        });
    }

    public Preferences getPreferences() {
        return NbPreferences.forModule(BugtrackingSupport.class);
    }

    public void storeColumns(String key, String columns) {
        this.getPreferences().put("bugtracking.issuetable.columnwidth." + key, columns);
    }

    public String getColumns(String key) {
        return this.getPreferences().get("bugtracking.issuetable.columnwidth." + key, "");
    }

    @Deprecated
    public int[] getColumnWidths(String key) {
        ArrayList<Integer> retval = new ArrayList<Integer>();
        try {
            String[] keys = this.getPreferences().keys();
            for (int i = 0; i < keys.length; ++i) {
                String k = keys[i];
                if (k == null || !k.startsWith("bugtracking.issuetable.columnwidth." + key + ".")) continue;
                int idx = Integer.parseInt(k.substring(k.lastIndexOf(46) + 1));
                int value = this.getPreferences().getInt(k, -1);
                retval.add(idx, value);
                this.getPreferences().remove(k);
            }
            int[] ret = new int[retval.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (Integer)retval.get(i);
            }
            return ret;
        }
        catch (NumberFormatException | BackingStoreException ex) {
            LOG.log(Level.INFO, null, ex);
            return new int[0];
        }
    }

    public void storeColumnSorting(String columnsKey, String sorting) {
        this.getPreferences().put("bugtracking.issuetable.columnsorting." + columnsKey, sorting);
    }

    public String getColumnSorting(String key) {
        return this.getPreferences().get("bugtracking.issuetable.columnsorting." + key, "");
    }

    private class StoreColumnsHandler
    implements Runnable {
        private StoreColumnsHandler() {
        }

        @Override
        public void run() {
            TableColumnModel cm = IssueTable.this.table.getColumnModel();
            int count = cm.getColumnCount();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < count; ++i) {
                if (IssueTable.this.tableModel.getColumnId(i).equals("issue.seen")) continue;
                sb.append(IssueTable.this.tableModel.getColumnId(i));
                sb.append(IssueTable.CONFIG_DELIMITER);
                sb.append(cm.getColumn(i).getWidth());
                if (i >= count - 1) continue;
                sb.append(IssueTable.CONFIG_DELIMITER);
            }
            IssueTable.this.storeColumns(IssueTable.this.repositoryId, sb.toString());
        }
    }

    private class Cell {
        private final int row;
        private final int column;

        public Cell(int row, int column) {
            this.row = row;
            this.column = column;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Cell other = (Cell)obj;
            if (this.row != other.row) {
                return false;
            }
            return this.column == other.column;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append("row=");
            sb.append(this.row);
            sb.append(",column=");
            sb.append(this.column);
            sb.append("]");
            return sb.toString();
        }
    }

    private static class CellAction
    implements ActionListener {
        private final Rectangle bounds;
        private final ActionListener listener;

        public CellAction(Rectangle bounds, ActionListener listener) {
            this.bounds = bounds;
            this.listener = listener;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CellAction other = (CellAction)obj;
            return this.bounds == other.bounds || this.bounds != null && this.bounds.equals(other.bounds);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append("bounds=");
            sb.append(this.bounds);
            sb.append("]");
            return sb.toString();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.listener.actionPerformed(e);
        }
    }

    private static class RecentChangesDescriptor
    extends ColumnDescriptor<String> {
        public RecentChangesDescriptor() {
            super("issue.recent_changes", String.class, NbBundle.getBundle(IssueTable.class).getString("CTL_Issue_Recent"), NbBundle.getBundle(IssueTable.class).getString("CTL_Issue_Recent_Desc"), -1, true, true);
        }
    }

    private static class SeenDescriptor
    extends ColumnDescriptor<Boolean> {
        public SeenDescriptor() {
            super("issue.seen", Boolean.class, "", NbBundle.getBundle(IssueTable.class).getString("CTL_Issue_Seen_Desc"), -1, true, true);
        }
    }
}

