/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.containerengine.ContainerEngineAsync;
import com.oracle.bmc.containerengine.model.Addon;
import com.oracle.bmc.containerengine.model.AddonOptionSummary;
import com.oracle.bmc.containerengine.model.AddonSummary;
import com.oracle.bmc.containerengine.model.Cluster;
import com.oracle.bmc.containerengine.model.ClusterMigrateToNativeVcnStatus;
import com.oracle.bmc.containerengine.model.ClusterOptions;
import com.oracle.bmc.containerengine.model.ClusterSummary;
import com.oracle.bmc.containerengine.model.CredentialRotationStatus;
import com.oracle.bmc.containerengine.model.NodePool;
import com.oracle.bmc.containerengine.model.NodePoolOptions;
import com.oracle.bmc.containerengine.model.NodePoolSummary;
import com.oracle.bmc.containerengine.model.PodShapeSummary;
import com.oracle.bmc.containerengine.model.VirtualNode;
import com.oracle.bmc.containerengine.model.VirtualNodePool;
import com.oracle.bmc.containerengine.model.VirtualNodePoolSummary;
import com.oracle.bmc.containerengine.model.VirtualNodeSummary;
import com.oracle.bmc.containerengine.model.WorkRequest;
import com.oracle.bmc.containerengine.model.WorkRequestError;
import com.oracle.bmc.containerengine.model.WorkRequestLogEntry;
import com.oracle.bmc.containerengine.model.WorkRequestSummary;
import com.oracle.bmc.containerengine.model.WorkloadMapping;
import com.oracle.bmc.containerengine.model.WorkloadMappingSummary;
import com.oracle.bmc.containerengine.requests.ClusterMigrateToNativeVcnRequest;
import com.oracle.bmc.containerengine.requests.CompleteCredentialRotationRequest;
import com.oracle.bmc.containerengine.requests.CreateClusterRequest;
import com.oracle.bmc.containerengine.requests.CreateKubeconfigRequest;
import com.oracle.bmc.containerengine.requests.CreateNodePoolRequest;
import com.oracle.bmc.containerengine.requests.CreateVirtualNodePoolRequest;
import com.oracle.bmc.containerengine.requests.CreateWorkloadMappingRequest;
import com.oracle.bmc.containerengine.requests.DeleteClusterRequest;
import com.oracle.bmc.containerengine.requests.DeleteNodePoolRequest;
import com.oracle.bmc.containerengine.requests.DeleteNodeRequest;
import com.oracle.bmc.containerengine.requests.DeleteVirtualNodePoolRequest;
import com.oracle.bmc.containerengine.requests.DeleteWorkRequestRequest;
import com.oracle.bmc.containerengine.requests.DeleteWorkloadMappingRequest;
import com.oracle.bmc.containerengine.requests.DisableAddonRequest;
import com.oracle.bmc.containerengine.requests.GetAddonRequest;
import com.oracle.bmc.containerengine.requests.GetClusterMigrateToNativeVcnStatusRequest;
import com.oracle.bmc.containerengine.requests.GetClusterOptionsRequest;
import com.oracle.bmc.containerengine.requests.GetClusterRequest;
import com.oracle.bmc.containerengine.requests.GetCredentialRotationStatusRequest;
import com.oracle.bmc.containerengine.requests.GetNodePoolOptionsRequest;
import com.oracle.bmc.containerengine.requests.GetNodePoolRequest;
import com.oracle.bmc.containerengine.requests.GetVirtualNodePoolRequest;
import com.oracle.bmc.containerengine.requests.GetVirtualNodeRequest;
import com.oracle.bmc.containerengine.requests.GetWorkRequestRequest;
import com.oracle.bmc.containerengine.requests.GetWorkloadMappingRequest;
import com.oracle.bmc.containerengine.requests.InstallAddonRequest;
import com.oracle.bmc.containerengine.requests.ListAddonOptionsRequest;
import com.oracle.bmc.containerengine.requests.ListAddonsRequest;
import com.oracle.bmc.containerengine.requests.ListClustersRequest;
import com.oracle.bmc.containerengine.requests.ListNodePoolsRequest;
import com.oracle.bmc.containerengine.requests.ListPodShapesRequest;
import com.oracle.bmc.containerengine.requests.ListVirtualNodePoolsRequest;
import com.oracle.bmc.containerengine.requests.ListVirtualNodesRequest;
import com.oracle.bmc.containerengine.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.containerengine.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.containerengine.requests.ListWorkRequestsRequest;
import com.oracle.bmc.containerengine.requests.ListWorkloadMappingsRequest;
import com.oracle.bmc.containerengine.requests.StartCredentialRotationRequest;
import com.oracle.bmc.containerengine.requests.UpdateAddonRequest;
import com.oracle.bmc.containerengine.requests.UpdateClusterEndpointConfigRequest;
import com.oracle.bmc.containerengine.requests.UpdateClusterRequest;
import com.oracle.bmc.containerengine.requests.UpdateNodePoolRequest;
import com.oracle.bmc.containerengine.requests.UpdateVirtualNodePoolRequest;
import com.oracle.bmc.containerengine.requests.UpdateWorkloadMappingRequest;
import com.oracle.bmc.containerengine.responses.ClusterMigrateToNativeVcnResponse;
import com.oracle.bmc.containerengine.responses.CompleteCredentialRotationResponse;
import com.oracle.bmc.containerengine.responses.CreateClusterResponse;
import com.oracle.bmc.containerengine.responses.CreateKubeconfigResponse;
import com.oracle.bmc.containerengine.responses.CreateNodePoolResponse;
import com.oracle.bmc.containerengine.responses.CreateVirtualNodePoolResponse;
import com.oracle.bmc.containerengine.responses.CreateWorkloadMappingResponse;
import com.oracle.bmc.containerengine.responses.DeleteClusterResponse;
import com.oracle.bmc.containerengine.responses.DeleteNodePoolResponse;
import com.oracle.bmc.containerengine.responses.DeleteNodeResponse;
import com.oracle.bmc.containerengine.responses.DeleteVirtualNodePoolResponse;
import com.oracle.bmc.containerengine.responses.DeleteWorkRequestResponse;
import com.oracle.bmc.containerengine.responses.DeleteWorkloadMappingResponse;
import com.oracle.bmc.containerengine.responses.DisableAddonResponse;
import com.oracle.bmc.containerengine.responses.GetAddonResponse;
import com.oracle.bmc.containerengine.responses.GetClusterMigrateToNativeVcnStatusResponse;
import com.oracle.bmc.containerengine.responses.GetClusterOptionsResponse;
import com.oracle.bmc.containerengine.responses.GetClusterResponse;
import com.oracle.bmc.containerengine.responses.GetCredentialRotationStatusResponse;
import com.oracle.bmc.containerengine.responses.GetNodePoolOptionsResponse;
import com.oracle.bmc.containerengine.responses.GetNodePoolResponse;
import com.oracle.bmc.containerengine.responses.GetVirtualNodePoolResponse;
import com.oracle.bmc.containerengine.responses.GetVirtualNodeResponse;
import com.oracle.bmc.containerengine.responses.GetWorkRequestResponse;
import com.oracle.bmc.containerengine.responses.GetWorkloadMappingResponse;
import com.oracle.bmc.containerengine.responses.InstallAddonResponse;
import com.oracle.bmc.containerengine.responses.ListAddonOptionsResponse;
import com.oracle.bmc.containerengine.responses.ListAddonsResponse;
import com.oracle.bmc.containerengine.responses.ListClustersResponse;
import com.oracle.bmc.containerengine.responses.ListNodePoolsResponse;
import com.oracle.bmc.containerengine.responses.ListPodShapesResponse;
import com.oracle.bmc.containerengine.responses.ListVirtualNodePoolsResponse;
import com.oracle.bmc.containerengine.responses.ListVirtualNodesResponse;
import com.oracle.bmc.containerengine.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.containerengine.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.containerengine.responses.ListWorkRequestsResponse;
import com.oracle.bmc.containerengine.responses.ListWorkloadMappingsResponse;
import com.oracle.bmc.containerengine.responses.StartCredentialRotationResponse;
import com.oracle.bmc.containerengine.responses.UpdateAddonResponse;
import com.oracle.bmc.containerengine.responses.UpdateClusterEndpointConfigResponse;
import com.oracle.bmc.containerengine.responses.UpdateClusterResponse;
import com.oracle.bmc.containerengine.responses.UpdateNodePoolResponse;
import com.oracle.bmc.containerengine.responses.UpdateVirtualNodePoolResponse;
import com.oracle.bmc.containerengine.responses.UpdateWorkloadMappingResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerEngineAsyncClient
extends BaseAsyncClient
implements ContainerEngineAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("CONTAINERENGINE").serviceEndpointPrefix("containerengine").serviceEndpointTemplate("https://containerengine.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ContainerEngineAsyncClient.class);

    ContainerEngineAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(builder, authenticationDetailsProvider, true);
    }

    ContainerEngineAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"ContainerEngineAsyncClient", (String)"createKubeconfig"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ClusterMigrateToNativeVcnResponse> clusterMigrateToNativeVcn(ClusterMigrateToNativeVcnRequest request, AsyncHandler<ClusterMigrateToNativeVcnRequest, ClusterMigrateToNativeVcnResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getClusterMigrateToNativeVcnDetails(), "clusterMigrateToNativeVcnDetails is required");
        return this.clientCall(request, ClusterMigrateToNativeVcnResponse::builder).logger(LOG, "clusterMigrateToNativeVcn").serviceDetails("ContainerEngine", "ClusterMigrateToNativeVcn", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/ClusterMigrateToNativeVcn").method(Method.POST).requestBuilder(ClusterMigrateToNativeVcnRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("actions").appendPathParam("migrateToNativeVcn").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ClusterMigrateToNativeVcnResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ClusterMigrateToNativeVcnResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CompleteCredentialRotationResponse> completeCredentialRotation(CompleteCredentialRotationRequest request, AsyncHandler<CompleteCredentialRotationRequest, CompleteCredentialRotationResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CompleteCredentialRotationResponse::builder).logger(LOG, "completeCredentialRotation").serviceDetails("ContainerEngine", "CompleteCredentialRotation", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/CompleteCredentialRotation").method(Method.POST).requestBuilder(CompleteCredentialRotationRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("actions").appendPathParam("completeCredentialRotation").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-work-request-id", CompleteCredentialRotationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CompleteCredentialRotationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateClusterResponse> createCluster(CreateClusterRequest request, AsyncHandler<CreateClusterRequest, CreateClusterResponse> handler) {
        Objects.requireNonNull(request.getCreateClusterDetails(), "createClusterDetails is required");
        return this.clientCall(request, CreateClusterResponse::builder).logger(LOG, "createCluster").serviceDetails("ContainerEngine", "CreateCluster", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/CreateCluster").method(Method.POST).requestBuilder(CreateClusterRequest::builder).basePath("/20180222").appendPathParam("clusters").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateKubeconfigResponse> createKubeconfig(CreateKubeconfigRequest request, AsyncHandler<CreateKubeconfigRequest, CreateKubeconfigResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CreateKubeconfigResponse::builder).logger(LOG, "createKubeconfig").serviceDetails("ContainerEngine", "CreateKubeconfig", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/CreateKubeconfig").method(Method.POST).requestBuilder(CreateKubeconfigRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("kubeconfig").appendPathParam("content").accept(new String[]{"application/x-yaml"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(InputStream.class, CreateKubeconfigResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", CreateKubeconfigResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateNodePoolResponse> createNodePool(CreateNodePoolRequest request, AsyncHandler<CreateNodePoolRequest, CreateNodePoolResponse> handler) {
        Objects.requireNonNull(request.getCreateNodePoolDetails(), "createNodePoolDetails is required");
        return this.clientCall(request, CreateNodePoolResponse::builder).logger(LOG, "createNodePool").serviceDetails("ContainerEngine", "CreateNodePool", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/NodePool/CreateNodePool").method(Method.POST).requestBuilder(CreateNodePoolRequest::builder).basePath("/20180222").appendPathParam("nodePools").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateNodePoolResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateNodePoolResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateVirtualNodePoolResponse> createVirtualNodePool(CreateVirtualNodePoolRequest request, AsyncHandler<CreateVirtualNodePoolRequest, CreateVirtualNodePoolResponse> handler) {
        Objects.requireNonNull(request.getCreateVirtualNodePoolDetails(), "createVirtualNodePoolDetails is required");
        return this.clientCall(request, CreateVirtualNodePoolResponse::builder).logger(LOG, "createVirtualNodePool").serviceDetails("ContainerEngine", "CreateVirtualNodePool", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/VirtualNodePool/CreateVirtualNodePool").method(Method.POST).requestBuilder(CreateVirtualNodePoolRequest::builder).basePath("/20180222").appendPathParam("virtualNodePools").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateVirtualNodePoolResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateVirtualNodePoolResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateWorkloadMappingResponse> createWorkloadMapping(CreateWorkloadMappingRequest request, AsyncHandler<CreateWorkloadMappingRequest, CreateWorkloadMappingResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateWorkloadMappingDetails(), "createWorkloadMappingDetails is required");
        return this.clientCall(request, CreateWorkloadMappingResponse::builder).logger(LOG, "createWorkloadMapping").serviceDetails("ContainerEngine", "CreateWorkloadMapping", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/WorkloadMapping/CreateWorkloadMapping").method(Method.POST).requestBuilder(CreateWorkloadMappingRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("workloadMappings").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(WorkloadMapping.class, CreateWorkloadMappingResponse.Builder::workloadMapping).handleResponseHeaderString("etag", CreateWorkloadMappingResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateWorkloadMappingResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteClusterResponse> deleteCluster(DeleteClusterRequest request, AsyncHandler<DeleteClusterRequest, DeleteClusterResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteClusterResponse::builder).logger(LOG, "deleteCluster").serviceDetails("ContainerEngine", "DeleteCluster", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/DeleteCluster").method(Method.DELETE).requestBuilder(DeleteClusterRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteNodeResponse> deleteNode(DeleteNodeRequest request, AsyncHandler<DeleteNodeRequest, DeleteNodeResponse> handler) {
        Validate.notBlank((String)request.getNodePoolId(), (String)"nodePoolId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getNodeId(), (String)"nodeId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteNodeResponse::builder).logger(LOG, "deleteNode").serviceDetails("ContainerEngine", "DeleteNode", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/NodePool/DeleteNode").method(Method.DELETE).requestBuilder(DeleteNodeRequest::builder).basePath("/20180222").appendPathParam("nodePools").appendPathParam(request.getNodePoolId()).appendPathParam("node").appendPathParam(request.getNodeId()).appendQueryParam("isDecrementSize", (Object)request.getIsDecrementSize()).appendQueryParam("overrideEvictionGraceDuration", (Object)request.getOverrideEvictionGraceDuration()).appendQueryParam("isForceDeletionAfterOverrideGraceDuration", (Object)request.getIsForceDeletionAfterOverrideGraceDuration()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteNodeResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteNodeResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteNodePoolResponse> deleteNodePool(DeleteNodePoolRequest request, AsyncHandler<DeleteNodePoolRequest, DeleteNodePoolResponse> handler) {
        Validate.notBlank((String)request.getNodePoolId(), (String)"nodePoolId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteNodePoolResponse::builder).logger(LOG, "deleteNodePool").serviceDetails("ContainerEngine", "DeleteNodePool", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/NodePool/DeleteNodePool").method(Method.DELETE).requestBuilder(DeleteNodePoolRequest::builder).basePath("/20180222").appendPathParam("nodePools").appendPathParam(request.getNodePoolId()).appendQueryParam("overrideEvictionGraceDuration", (Object)request.getOverrideEvictionGraceDuration()).appendQueryParam("isForceDeletionAfterOverrideGraceDuration", (Object)request.getIsForceDeletionAfterOverrideGraceDuration()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteNodePoolResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteNodePoolResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteVirtualNodePoolResponse> deleteVirtualNodePool(DeleteVirtualNodePoolRequest request, AsyncHandler<DeleteVirtualNodePoolRequest, DeleteVirtualNodePoolResponse> handler) {
        Validate.notBlank((String)request.getVirtualNodePoolId(), (String)"virtualNodePoolId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteVirtualNodePoolResponse::builder).logger(LOG, "deleteVirtualNodePool").serviceDetails("ContainerEngine", "DeleteVirtualNodePool", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/VirtualNodePool/DeleteVirtualNodePool").method(Method.DELETE).requestBuilder(DeleteVirtualNodePoolRequest::builder).basePath("/20180222").appendPathParam("virtualNodePools").appendPathParam(request.getVirtualNodePoolId()).appendQueryParam("overrideEvictionGraceDurationVnp", (Object)request.getOverrideEvictionGraceDurationVnp()).appendQueryParam("isForceDeletionAfterOverrideGraceDurationVnp", (Object)request.getIsForceDeletionAfterOverrideGraceDurationVnp()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteVirtualNodePoolResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteVirtualNodePoolResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteWorkRequestResponse> deleteWorkRequest(DeleteWorkRequestRequest request, AsyncHandler<DeleteWorkRequestRequest, DeleteWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteWorkRequestResponse::builder).logger(LOG, "deleteWorkRequest").serviceDetails("ContainerEngine", "DeleteWorkRequest", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/WorkRequest/DeleteWorkRequest").method(Method.DELETE).requestBuilder(DeleteWorkRequestRequest::builder).basePath("/20180222").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteWorkRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteWorkloadMappingResponse> deleteWorkloadMapping(DeleteWorkloadMappingRequest request, AsyncHandler<DeleteWorkloadMappingRequest, DeleteWorkloadMappingResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getWorkloadMappingId(), (String)"workloadMappingId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteWorkloadMappingResponse::builder).logger(LOG, "deleteWorkloadMapping").serviceDetails("ContainerEngine", "DeleteWorkloadMapping", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/WorkloadMapping/DeleteWorkloadMapping").method(Method.DELETE).requestBuilder(DeleteWorkloadMappingRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("workloadMappings").appendPathParam(request.getWorkloadMappingId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteWorkloadMappingResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DisableAddonResponse> disableAddon(DisableAddonRequest request, AsyncHandler<DisableAddonRequest, DisableAddonResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAddonName(), (String)"addonName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getIsRemoveExistingAddOn(), "isRemoveExistingAddOn is required");
        return this.clientCall(request, DisableAddonResponse::builder).logger(LOG, "disableAddon").serviceDetails("ContainerEngine", "DisableAddon", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/DisableAddon").method(Method.DELETE).requestBuilder(DisableAddonRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("addons").appendPathParam(request.getAddonName()).appendQueryParam("isRemoveExistingAddOn", (Object)request.getIsRemoveExistingAddOn()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DisableAddonResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DisableAddonResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetAddonResponse> getAddon(GetAddonRequest request, AsyncHandler<GetAddonRequest, GetAddonResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAddonName(), (String)"addonName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAddonResponse::builder).logger(LOG, "getAddon").serviceDetails("ContainerEngine", "GetAddon", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/GetAddon").method(Method.GET).requestBuilder(GetAddonRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("addons").appendPathParam(request.getAddonName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Addon.class, GetAddonResponse.Builder::addon).handleResponseHeaderString("etag", GetAddonResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAddonResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetClusterResponse> getCluster(GetClusterRequest request, AsyncHandler<GetClusterRequest, GetClusterResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetClusterResponse::builder).logger(LOG, "getCluster").serviceDetails("ContainerEngine", "GetCluster", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/GetCluster").method(Method.GET).requestBuilder(GetClusterRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Cluster.class, GetClusterResponse.Builder::cluster).handleResponseHeaderString("etag", GetClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetClusterMigrateToNativeVcnStatusResponse> getClusterMigrateToNativeVcnStatus(GetClusterMigrateToNativeVcnStatusRequest request, AsyncHandler<GetClusterMigrateToNativeVcnStatusRequest, GetClusterMigrateToNativeVcnStatusResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetClusterMigrateToNativeVcnStatusResponse::builder).logger(LOG, "getClusterMigrateToNativeVcnStatus").serviceDetails("ContainerEngine", "GetClusterMigrateToNativeVcnStatus", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/ClusterMigrateToNativeVcnStatus/GetClusterMigrateToNativeVcnStatus").method(Method.GET).requestBuilder(GetClusterMigrateToNativeVcnStatusRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("migrateToNativeVcnStatus").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ClusterMigrateToNativeVcnStatus.class, GetClusterMigrateToNativeVcnStatusResponse.Builder::clusterMigrateToNativeVcnStatus).handleResponseHeaderString("etag", GetClusterMigrateToNativeVcnStatusResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetClusterMigrateToNativeVcnStatusResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetClusterOptionsResponse> getClusterOptions(GetClusterOptionsRequest request, AsyncHandler<GetClusterOptionsRequest, GetClusterOptionsResponse> handler) {
        Validate.notBlank((String)request.getClusterOptionId(), (String)"clusterOptionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetClusterOptionsResponse::builder).logger(LOG, "getClusterOptions").serviceDetails("ContainerEngine", "GetClusterOptions", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/ClusterOptions/GetClusterOptions").method(Method.GET).requestBuilder(GetClusterOptionsRequest::builder).basePath("/20180222").appendPathParam("clusterOptions").appendPathParam(request.getClusterOptionId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ClusterOptions.class, GetClusterOptionsResponse.Builder::clusterOptions).handleResponseHeaderString("opc-request-id", GetClusterOptionsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetCredentialRotationStatusResponse> getCredentialRotationStatus(GetCredentialRotationStatusRequest request, AsyncHandler<GetCredentialRotationStatusRequest, GetCredentialRotationStatusResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetCredentialRotationStatusResponse::builder).logger(LOG, "getCredentialRotationStatus").serviceDetails("ContainerEngine", "GetCredentialRotationStatus", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/CredentialRotationStatus/GetCredentialRotationStatus").method(Method.GET).requestBuilder(GetCredentialRotationStatusRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("credentialRotationStatus").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CredentialRotationStatus.class, GetCredentialRotationStatusResponse.Builder::credentialRotationStatus).handleResponseHeaderString("etag", GetCredentialRotationStatusResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCredentialRotationStatusResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetNodePoolResponse> getNodePool(GetNodePoolRequest request, AsyncHandler<GetNodePoolRequest, GetNodePoolResponse> handler) {
        Validate.notBlank((String)request.getNodePoolId(), (String)"nodePoolId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetNodePoolResponse::builder).logger(LOG, "getNodePool").serviceDetails("ContainerEngine", "GetNodePool", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/NodePool/GetNodePool").method(Method.GET).requestBuilder(GetNodePoolRequest::builder).basePath("/20180222").appendPathParam("nodePools").appendPathParam(request.getNodePoolId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NodePool.class, GetNodePoolResponse.Builder::nodePool).handleResponseHeaderString("etag", GetNodePoolResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetNodePoolResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetNodePoolOptionsResponse> getNodePoolOptions(GetNodePoolOptionsRequest request, AsyncHandler<GetNodePoolOptionsRequest, GetNodePoolOptionsResponse> handler) {
        Validate.notBlank((String)request.getNodePoolOptionId(), (String)"nodePoolOptionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetNodePoolOptionsResponse::builder).logger(LOG, "getNodePoolOptions").serviceDetails("ContainerEngine", "GetNodePoolOptions", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/NodePoolOptions/GetNodePoolOptions").method(Method.GET).requestBuilder(GetNodePoolOptionsRequest::builder).basePath("/20180222").appendPathParam("nodePoolOptions").appendPathParam(request.getNodePoolOptionId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NodePoolOptions.class, GetNodePoolOptionsResponse.Builder::nodePoolOptions).handleResponseHeaderString("opc-request-id", GetNodePoolOptionsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetVirtualNodeResponse> getVirtualNode(GetVirtualNodeRequest request, AsyncHandler<GetVirtualNodeRequest, GetVirtualNodeResponse> handler) {
        Validate.notBlank((String)request.getVirtualNodePoolId(), (String)"virtualNodePoolId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getVirtualNodeId(), (String)"virtualNodeId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetVirtualNodeResponse::builder).logger(LOG, "getVirtualNode").serviceDetails("ContainerEngine", "GetVirtualNode", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/VirtualNodePool/GetVirtualNode").method(Method.GET).requestBuilder(GetVirtualNodeRequest::builder).basePath("/20180222").appendPathParam("virtualNodePools").appendPathParam(request.getVirtualNodePoolId()).appendPathParam("virtualNodes").appendPathParam(request.getVirtualNodeId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(VirtualNode.class, GetVirtualNodeResponse.Builder::virtualNode).handleResponseHeaderString("etag", GetVirtualNodeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVirtualNodeResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetVirtualNodePoolResponse> getVirtualNodePool(GetVirtualNodePoolRequest request, AsyncHandler<GetVirtualNodePoolRequest, GetVirtualNodePoolResponse> handler) {
        Validate.notBlank((String)request.getVirtualNodePoolId(), (String)"virtualNodePoolId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetVirtualNodePoolResponse::builder).logger(LOG, "getVirtualNodePool").serviceDetails("ContainerEngine", "GetVirtualNodePool", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/VirtualNodePool/GetVirtualNodePool").method(Method.GET).requestBuilder(GetVirtualNodePoolRequest::builder).basePath("/20180222").appendPathParam("virtualNodePools").appendPathParam(request.getVirtualNodePoolId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(VirtualNodePool.class, GetVirtualNodePoolResponse.Builder::virtualNodePool).handleResponseHeaderString("etag", GetVirtualNodePoolResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVirtualNodePoolResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("ContainerEngine", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20180222").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<GetWorkloadMappingResponse> getWorkloadMapping(GetWorkloadMappingRequest request, AsyncHandler<GetWorkloadMappingRequest, GetWorkloadMappingResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getWorkloadMappingId(), (String)"workloadMappingId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkloadMappingResponse::builder).logger(LOG, "getWorkloadMapping").serviceDetails("ContainerEngine", "GetWorkloadMapping", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/WorkloadMapping/GetWorkloadMapping").method(Method.GET).requestBuilder(GetWorkloadMappingRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("workloadMappings").appendPathParam(request.getWorkloadMappingId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkloadMapping.class, GetWorkloadMappingResponse.Builder::workloadMapping).handleResponseHeaderString("etag", GetWorkloadMappingResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkloadMappingResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<InstallAddonResponse> installAddon(InstallAddonRequest request, AsyncHandler<InstallAddonRequest, InstallAddonResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getInstallAddonDetails(), "installAddonDetails is required");
        return this.clientCall(request, InstallAddonResponse::builder).logger(LOG, "installAddon").serviceDetails("ContainerEngine", "InstallAddon", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/InstallAddon").method(Method.POST).requestBuilder(InstallAddonRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("addons").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", InstallAddonResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", InstallAddonResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListAddonOptionsResponse> listAddonOptions(ListAddonOptionsRequest request, AsyncHandler<ListAddonOptionsRequest, ListAddonOptionsResponse> handler) {
        Objects.requireNonNull(request.getKubernetesVersion(), "kubernetesVersion is required");
        return this.clientCall(request, ListAddonOptionsResponse::builder).logger(LOG, "listAddonOptions").serviceDetails("ContainerEngine", "ListAddonOptions", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/AddonOptionSummary/ListAddonOptions").method(Method.GET).requestBuilder(ListAddonOptionsRequest::builder).basePath("/20180222").appendPathParam("addonOptions").appendQueryParam("kubernetesVersion", (Object)request.getKubernetesVersion()).appendQueryParam("addonName", (Object)request.getAddonName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(AddonOptionSummary.class, ListAddonOptionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListAddonOptionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAddonOptionsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListAddonsResponse> listAddons(ListAddonsRequest request, AsyncHandler<ListAddonsRequest, ListAddonsResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListAddonsResponse::builder).logger(LOG, "listAddons").serviceDetails("ContainerEngine", "ListAddons", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/ListAddons").method(Method.GET).requestBuilder(ListAddonsRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("addons").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(AddonSummary.class, ListAddonsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListAddonsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAddonsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListClustersResponse> listClusters(ListClustersRequest request, AsyncHandler<ListClustersRequest, ListClustersResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListClustersResponse::builder).logger(LOG, "listClusters").serviceDetails("ContainerEngine", "ListClusters", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/ClusterSummary/ListClusters").method(Method.GET).requestBuilder(ListClustersRequest::builder).basePath("/20180222").appendPathParam("clusters").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ClusterSummary.class, ListClustersResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListClustersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListClustersResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListNodePoolsResponse> listNodePools(ListNodePoolsRequest request, AsyncHandler<ListNodePoolsRequest, ListNodePoolsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListNodePoolsResponse::builder).logger(LOG, "listNodePools").serviceDetails("ContainerEngine", "ListNodePools", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/NodePoolSummary/ListNodePools").method(Method.GET).requestBuilder(ListNodePoolsRequest::builder).basePath("/20180222").appendPathParam("nodePools").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("clusterId", (Object)request.getClusterId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(NodePoolSummary.class, ListNodePoolsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListNodePoolsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListNodePoolsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListPodShapesResponse> listPodShapes(ListPodShapesRequest request, AsyncHandler<ListPodShapesRequest, ListPodShapesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListPodShapesResponse::builder).logger(LOG, "listPodShapes").serviceDetails("ContainerEngine", "ListPodShapes", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/PodShapeSummary/ListPodShapes").method(Method.GET).requestBuilder(ListPodShapesRequest::builder).basePath("/20180222").appendPathParam("podShapes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(PodShapeSummary.class, ListPodShapesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListPodShapesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListPodShapesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListVirtualNodePoolsResponse> listVirtualNodePools(ListVirtualNodePoolsRequest request, AsyncHandler<ListVirtualNodePoolsRequest, ListVirtualNodePoolsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListVirtualNodePoolsResponse::builder).logger(LOG, "listVirtualNodePools").serviceDetails("ContainerEngine", "ListVirtualNodePools", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/VirtualNodePoolSummary/ListVirtualNodePools").method(Method.GET).requestBuilder(ListVirtualNodePoolsRequest::builder).basePath("/20180222").appendPathParam("virtualNodePools").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("clusterId", (Object)request.getClusterId()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(VirtualNodePoolSummary.class, ListVirtualNodePoolsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListVirtualNodePoolsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListVirtualNodePoolsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListVirtualNodesResponse> listVirtualNodes(ListVirtualNodesRequest request, AsyncHandler<ListVirtualNodesRequest, ListVirtualNodesResponse> handler) {
        Validate.notBlank((String)request.getVirtualNodePoolId(), (String)"virtualNodePoolId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListVirtualNodesResponse::builder).logger(LOG, "listVirtualNodes").serviceDetails("ContainerEngine", "ListVirtualNodes", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/VirtualNodePool/ListVirtualNodes").method(Method.GET).requestBuilder(ListVirtualNodesRequest::builder).basePath("/20180222").appendPathParam("virtualNodePools").appendPathParam(request.getVirtualNodePoolId()).appendPathParam("virtualNodes").appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(VirtualNodeSummary.class, ListVirtualNodesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListVirtualNodesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListVirtualNodesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("ContainerEngine", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20180222").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("ContainerEngine", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20180222").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestLogEntry.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("ContainerEngine", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/WorkRequestSummary/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20180222").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("clusterId", (Object)request.getClusterId()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendEnumQueryParam("resourceType", (BmcEnum)request.getResourceType()).appendListQueryParam("status", request.getStatus(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestSummary.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkloadMappingsResponse> listWorkloadMappings(ListWorkloadMappingsRequest request, AsyncHandler<ListWorkloadMappingsRequest, ListWorkloadMappingsResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkloadMappingsResponse::builder).logger(LOG, "listWorkloadMappings").serviceDetails("ContainerEngine", "ListWorkloadMappings", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/WorkloadMappingSummary/ListWorkloadMappings").method(Method.GET).requestBuilder(ListWorkloadMappingsRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("workloadMappings").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkloadMappingSummary.class, ListWorkloadMappingsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkloadMappingsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkloadMappingsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<StartCredentialRotationResponse> startCredentialRotation(StartCredentialRotationRequest request, AsyncHandler<StartCredentialRotationRequest, StartCredentialRotationResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getStartCredentialRotationDetails(), "startCredentialRotationDetails is required");
        return this.clientCall(request, StartCredentialRotationResponse::builder).logger(LOG, "startCredentialRotation").serviceDetails("ContainerEngine", "StartCredentialRotation", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/StartCredentialRotation").method(Method.POST).requestBuilder(StartCredentialRotationRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("actions").appendPathParam("startCredentialRotation").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", StartCredentialRotationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StartCredentialRotationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateAddonResponse> updateAddon(UpdateAddonRequest request, AsyncHandler<UpdateAddonRequest, UpdateAddonResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAddonName(), (String)"addonName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAddonDetails(), "updateAddonDetails is required");
        return this.clientCall(request, UpdateAddonResponse::builder).logger(LOG, "updateAddon").serviceDetails("ContainerEngine", "UpdateAddon", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/UpdateAddon").method(Method.PUT).requestBuilder(UpdateAddonRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("addons").appendPathParam(request.getAddonName()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateAddonResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateAddonResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateClusterResponse> updateCluster(UpdateClusterRequest request, AsyncHandler<UpdateClusterRequest, UpdateClusterResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateClusterDetails(), "updateClusterDetails is required");
        return this.clientCall(request, UpdateClusterResponse::builder).logger(LOG, "updateCluster").serviceDetails("ContainerEngine", "UpdateCluster", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/UpdateCluster").method(Method.PUT).requestBuilder(UpdateClusterRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateClusterResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateClusterEndpointConfigResponse> updateClusterEndpointConfig(UpdateClusterEndpointConfigRequest request, AsyncHandler<UpdateClusterEndpointConfigRequest, UpdateClusterEndpointConfigResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateClusterEndpointConfigDetails(), "updateClusterEndpointConfigDetails is required");
        return this.clientCall(request, UpdateClusterEndpointConfigResponse::builder).logger(LOG, "updateClusterEndpointConfig").serviceDetails("ContainerEngine", "UpdateClusterEndpointConfig", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/Cluster/UpdateClusterEndpointConfig").method(Method.POST).requestBuilder(UpdateClusterEndpointConfigRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("actions").appendPathParam("updateEndpointConfig").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateClusterEndpointConfigResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateClusterEndpointConfigResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateNodePoolResponse> updateNodePool(UpdateNodePoolRequest request, AsyncHandler<UpdateNodePoolRequest, UpdateNodePoolResponse> handler) {
        Validate.notBlank((String)request.getNodePoolId(), (String)"nodePoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateNodePoolDetails(), "updateNodePoolDetails is required");
        return this.clientCall(request, UpdateNodePoolResponse::builder).logger(LOG, "updateNodePool").serviceDetails("ContainerEngine", "UpdateNodePool", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/NodePool/UpdateNodePool").method(Method.PUT).requestBuilder(UpdateNodePoolRequest::builder).basePath("/20180222").appendPathParam("nodePools").appendPathParam(request.getNodePoolId()).appendQueryParam("overrideEvictionGraceDuration", (Object)request.getOverrideEvictionGraceDuration()).appendQueryParam("isForceDeletionAfterOverrideGraceDuration", (Object)request.getIsForceDeletionAfterOverrideGraceDuration()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateNodePoolResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateNodePoolResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateVirtualNodePoolResponse> updateVirtualNodePool(UpdateVirtualNodePoolRequest request, AsyncHandler<UpdateVirtualNodePoolRequest, UpdateVirtualNodePoolResponse> handler) {
        Validate.notBlank((String)request.getVirtualNodePoolId(), (String)"virtualNodePoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVirtualNodePoolDetails(), "updateVirtualNodePoolDetails is required");
        return this.clientCall(request, UpdateVirtualNodePoolResponse::builder).logger(LOG, "updateVirtualNodePool").serviceDetails("ContainerEngine", "UpdateVirtualNodePool", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/VirtualNodePool/UpdateVirtualNodePool").method(Method.PUT).requestBuilder(UpdateVirtualNodePoolRequest::builder).basePath("/20180222").appendPathParam("virtualNodePools").appendPathParam(request.getVirtualNodePoolId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateVirtualNodePoolResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateVirtualNodePoolResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateWorkloadMappingResponse> updateWorkloadMapping(UpdateWorkloadMappingRequest request, AsyncHandler<UpdateWorkloadMappingRequest, UpdateWorkloadMappingResponse> handler) {
        Validate.notBlank((String)request.getClusterId(), (String)"clusterId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getWorkloadMappingId(), (String)"workloadMappingId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateWorkloadMappingDetails(), "updateWorkloadMappingDetails is required");
        return this.clientCall(request, UpdateWorkloadMappingResponse::builder).logger(LOG, "updateWorkloadMapping").serviceDetails("ContainerEngine", "UpdateWorkloadMapping", "https://docs.oracle.com/iaas/api/#/en/containerengine/20180222/WorkloadMapping/UpdateWorkloadMapping").method(Method.PUT).requestBuilder(UpdateWorkloadMappingRequest::builder).basePath("/20180222").appendPathParam("clusters").appendPathParam(request.getClusterId()).appendPathParam("workloadMappings").appendPathParam(request.getWorkloadMappingId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(WorkloadMapping.class, UpdateWorkloadMappingResponse.Builder::workloadMapping).handleResponseHeaderString("etag", UpdateWorkloadMappingResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateWorkloadMappingResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public ContainerEngineAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ContainerEngineAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ContainerEngineAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ContainerEngineAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ContainerEngineAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ContainerEngineAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ContainerEngineAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ContainerEngineAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ContainerEngineAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ContainerEngineAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ContainerEngineAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ContainerEngineAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ContainerEngineAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ContainerEngineAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ContainerEngineAsyncClient> {
        private boolean isStreamWarningEnabled = true;

        private Builder(Service service) {
            super(service);
            String packageName = "containerengine";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"containerengine");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public ContainerEngineAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ContainerEngineAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.isStreamWarningEnabled);
        }
    }
}

