/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.builder.event;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.builder.event.DocumentBuilderEvent;

public class ImageLinkEvent
extends DocumentBuilderEvent {
    private final Attributes linkAttributes;
    private final String href;
    private final Attributes imageAttributes;
    private final String imageUrl;

    public ImageLinkEvent(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        this.linkAttributes = ((Attributes)Preconditions.checkNotNull((Object)linkAttributes, (Object)"Must provide linkAttributes")).clone();
        this.imageAttributes = ((Attributes)Preconditions.checkNotNull((Object)imageAttributes, (Object)"Must provide imageAttributes")).clone();
        this.href = (String)Preconditions.checkNotNull((Object)href, (Object)"Must provide link href");
        this.imageUrl = (String)Preconditions.checkNotNull((Object)imageUrl, (Object)"Must provide imageUrl");
    }

    @Override
    public void invoke(DocumentBuilder builder) {
        builder.imageLink(this.linkAttributes, this.imageAttributes, this.href, this.imageUrl);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.href, this.imageUrl});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ImageLinkEvent)) {
            return false;
        }
        ImageLinkEvent other = (ImageLinkEvent)obj;
        return Objects.equal((Object)this.href, (Object)other.href) && Objects.equal((Object)this.imageUrl, (Object)other.imageUrl);
    }

    public String toString() {
        return String.format("imageLink(%s,%s)", this.href, this.imageUrl);
    }
}

