/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.settings.storage.MimeTypesTracker;
import org.netbeans.modules.editor.settings.storage.NbUtils;
import org.netbeans.modules.editor.settings.storage.ProfilesTracker;
import org.netbeans.modules.editor.settings.storage.StorageImpl;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.FontColorSettingsFactory;
import org.netbeans.modules.editor.settings.storage.api.KeyBindingSettingsFactory;
import org.netbeans.modules.editor.settings.storage.fontscolors.ColoringStorage;
import org.netbeans.modules.editor.settings.storage.fontscolors.FontColorSettingsImpl;
import org.netbeans.modules.editor.settings.storage.keybindings.KeyBindingSettingsImpl;
import org.netbeans.modules.editor.settings.storage.spi.StorageDescription;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class EditorSettingsImpl
extends EditorSettings {
    private static final Logger LOG = Logger.getLogger(EditorSettingsImpl.class.getName());
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    public static final String PROP_HIGHLIGHT_COLORINGS = "editorFontColors";
    public static final String PROP_ANNOTATION_COLORINGS = "editorAnnotationFontColors";
    public static final String PROP_TOKEN_COLORINGS = "fontColors";
    public static final String DEFAULT_PROFILE = "NetBeans";
    private static final String FATTR_CURRENT_FONT_COLOR_PROFILE = "currentFontColorProfile";
    private static final String FATTR_CURRENT_KEYMAP_PROFILE = "currentKeymap";
    public static final String EDITORS_FOLDER = "Editors";
    private static final String KEYMAPS_FOLDER = "Keymaps";
    public static final String TEXT_BASE_MIME_TYPE = "text/base";
    private static final String[] EMPTY = new String[0];
    private static EditorSettingsImpl instance = null;
    private final Set<String> cacheFontColorProfiles = new HashSet<String>();
    private String currentFontColorProfile;
    private final Map<String, Map<String, AttributeSet>> highlightings = new HashMap<String, Map<String, AttributeSet>>();
    private final StorageImpl<String, AttributeSet> highlightingsStorage = new StorageImpl((StorageDescription)new ColoringStorage("highlight"), null);
    private final Map<String, Map<String, AttributeSet>> annotations = new HashMap<String, Map<String, AttributeSet>>();
    private final StorageImpl<String, AttributeSet> annotationsStorage = new StorageImpl((StorageDescription)new ColoringStorage("annotation"), null);
    private volatile String currentKeyMapProfile;
    private KeymapProfileTracker tracker;

    public static synchronized EditorSettingsImpl getInstance() {
        if (instance == null) {
            instance = new EditorSettingsImpl();
        }
        return instance;
    }

    public void notifyMimeTypesChange(Object old, Object nue) {
        this.pcs.firePropertyChange(new PropertyChangeEvent(this, "mime-types", old, nue));
    }

    @Override
    public Set<String> getAllMimeTypes() {
        return MimeTypesTracker.get(null, EDITORS_FOLDER).getMimeTypes();
    }

    @Override
    public Set<String> getMimeTypes() {
        return MimeTypesTracker.get("FontsColors", EDITORS_FOLDER).getMimeTypes();
    }

    @Override
    public String getLanguageName(String mimeType) {
        return MimeTypesTracker.get(null, EDITORS_FOLDER).getMimeTypeDisplayName(mimeType);
    }

    public void notifyTokenFontColorChange(MimePath mimePath, String profile) {
        this.pcs.firePropertyChange(PROP_TOKEN_COLORINGS, mimePath, profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getFontColorProfiles() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(ProfilesTracker.get("FontsColors", EDITORS_FOLDER).getProfilesDisplayNames());
        EditorSettingsImpl editorSettingsImpl = this;
        synchronized (editorSettingsImpl) {
            this.cacheFontColorProfiles.removeAll(result);
            result.addAll(this.cacheFontColorProfiles);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCustomFontColorProfile(String profile) {
        ProfilesTracker tracker = ProfilesTracker.get("FontsColors", EDITORS_FOLDER);
        ProfilesTracker.ProfileDescription pd = tracker.getProfileByDisplayName(profile);
        EditorSettingsImpl editorSettingsImpl = this;
        synchronized (editorSettingsImpl) {
            boolean inCache = this.cacheFontColorProfiles.contains(profile);
            return pd != null && !pd.isRollbackAllowed() || inCache;
        }
    }

    @Override
    public synchronized String getCurrentFontColorProfile() {
        if (this.currentFontColorProfile == null) {
            Object o;
            FileObject fo = FileUtil.getConfigFile((String)EDITORS_FOLDER);
            if (fo != null && (o = fo.getAttribute(FATTR_CURRENT_FONT_COLOR_PROFILE)) instanceof String) {
                this.currentFontColorProfile = (String)o;
            }
            if (this.currentFontColorProfile == null) {
                this.currentFontColorProfile = DEFAULT_PROFILE;
            }
        }
        if (!this.getFontColorProfiles().contains(this.currentFontColorProfile)) {
            this.currentFontColorProfile = DEFAULT_PROFILE;
        }
        return this.currentFontColorProfile;
    }

    @Override
    public synchronized void setCurrentFontColorProfile(String profile) {
        FileObject fo;
        String oldProfile = this.getCurrentFontColorProfile();
        if (oldProfile.equals(profile)) {
            return;
        }
        this.currentFontColorProfile = profile;
        if (!this.getFontColorProfiles().contains(this.currentFontColorProfile)) {
            this.cacheFontColorProfiles.add(this.currentFontColorProfile);
        }
        if ((fo = FileUtil.getConfigFile((String)EDITORS_FOLDER)) != null) {
            try {
                fo.setAttribute(FATTR_CURRENT_FONT_COLOR_PROFILE, (Object)profile);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Can't persist change in current font&colors profile.", ex);
            }
        }
        this.pcs.firePropertyChange(FATTR_CURRENT_FONT_COLOR_PROFILE, oldProfile, this.currentFontColorProfile);
    }

    @Override
    @Deprecated
    public Collection<AttributeSet> getDefaultFontColors(String profile) {
        return this.getFontColorSettings(new String[0]).getAllFontColors(profile);
    }

    @Override
    @Deprecated
    public Collection<AttributeSet> getDefaultFontColorDefaults(String profile) {
        return this.getFontColorSettings(new String[0]).getAllFontColorDefaults(profile);
    }

    @Override
    @Deprecated
    public void setDefaultFontColors(String profile, Collection<AttributeSet> fontColors) {
        this.getFontColorSettings(new String[0]).setAllFontColors(profile, fontColors);
    }

    @Override
    public Map<String, AttributeSet> getHighlightings(String profile) {
        Map<String, AttributeSet> h;
        boolean specialProfile = profile.startsWith("test");
        profile = FontColorSettingsImpl.get(MimePath.EMPTY).getInternalFontColorProfile(profile);
        if (!this.highlightings.containsKey(profile)) {
            Map profileColorings = null;
            try {
                profileColorings = this.highlightingsStorage.load(MimePath.EMPTY, specialProfile ? DEFAULT_PROFILE : profile, false);
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, null, ioe);
            }
            Map defaultProfileColorings = null;
            if (!specialProfile && !DEFAULT_PROFILE.equals(profile)) {
                try {
                    defaultProfileColorings = this.highlightingsStorage.load(MimePath.EMPTY, DEFAULT_PROFILE, false);
                }
                catch (IOException ioe) {
                    LOG.log(Level.WARNING, null, ioe);
                }
            }
            HashMap m = new HashMap();
            if (defaultProfileColorings != null) {
                m.putAll(defaultProfileColorings);
            }
            if (profileColorings != null) {
                m.putAll(profileColorings);
            }
            profileColorings = Collections.unmodifiableMap(m);
            this.highlightings.put(profile, profileColorings);
        }
        return (h = this.highlightings.get(profile)) == null ? Collections.emptyMap() : h;
    }

    @Override
    public Map<String, AttributeSet> getHighlightingDefaults(String profile) {
        profile = FontColorSettingsImpl.get(MimePath.EMPTY).getInternalFontColorProfile(profile);
        try {
            return this.highlightingsStorage.load(MimePath.EMPTY, profile, true);
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, null, ioe);
            return Collections.emptyMap();
        }
    }

    @Override
    public void setHighlightings(String profile, Map<String, AttributeSet> fontColors) {
        boolean specialProfile = profile.startsWith("test");
        profile = FontColorSettingsImpl.get(MimePath.EMPTY).getInternalFontColorProfile(profile);
        if (fontColors == null) {
            try {
                this.highlightingsStorage.delete(MimePath.EMPTY, profile, false);
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, null, ioe);
            }
            this.highlightings.remove(profile);
        } else {
            Map<String, AttributeSet> m = NbUtils.immutize(fontColors, new Object[0]);
            if (!specialProfile) {
                try {
                    this.highlightingsStorage.save(MimePath.EMPTY, profile, false, m);
                }
                catch (IOException ioe) {
                    LOG.log(Level.WARNING, null, ioe);
                }
            }
            this.highlightings.put(profile, m);
        }
        this.pcs.firePropertyChange(PROP_HIGHLIGHT_COLORINGS, MimePath.EMPTY, profile);
    }

    @Override
    public Map<String, AttributeSet> getAnnotations(String profile) {
        Map<String, AttributeSet> h;
        boolean specialProfile = profile.startsWith("test");
        profile = FontColorSettingsImpl.get(MimePath.EMPTY).getInternalFontColorProfile(profile);
        if (!this.annotations.containsKey(profile)) {
            Map profileColorings = null;
            try {
                profileColorings = this.annotationsStorage.load(MimePath.EMPTY, specialProfile ? DEFAULT_PROFILE : profile, false);
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, null, ioe);
            }
            Map defaultProfileColorings = null;
            if (!specialProfile && !DEFAULT_PROFILE.equals(profile)) {
                try {
                    defaultProfileColorings = this.annotationsStorage.load(MimePath.EMPTY, DEFAULT_PROFILE, false);
                }
                catch (IOException ioe) {
                    LOG.log(Level.WARNING, null, ioe);
                }
            }
            HashMap m = new HashMap();
            if (profileColorings != null) {
                if (defaultProfileColorings != null) {
                    m.putAll(defaultProfileColorings);
                }
                m.putAll(profileColorings);
            }
            profileColorings = Collections.unmodifiableMap(m);
            this.annotations.put(profile, profileColorings);
        }
        return (h = this.annotations.get(profile)) == null ? Collections.emptyMap() : h;
    }

    @Override
    public Map<String, AttributeSet> getAnnotationDefaults(String profile) {
        profile = FontColorSettingsImpl.get(MimePath.EMPTY).getInternalFontColorProfile(profile);
        try {
            return this.annotationsStorage.load(MimePath.EMPTY, profile, true);
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, null, ioe);
            return Collections.emptyMap();
        }
    }

    @Override
    public void setAnnotations(String profile, Map<String, AttributeSet> fontColors) {
        boolean specialProfile = profile.startsWith("test");
        profile = FontColorSettingsImpl.get(MimePath.EMPTY).getInternalFontColorProfile(profile);
        if (fontColors == null) {
            try {
                this.annotationsStorage.delete(MimePath.EMPTY, profile, false);
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, null, ioe);
            }
            this.annotations.remove(profile);
        } else {
            Map<String, AttributeSet> m = NbUtils.immutize(fontColors, new Object[0]);
            if (!specialProfile) {
                try {
                    this.annotationsStorage.save(MimePath.EMPTY, profile, false, m);
                }
                catch (IOException ioe) {
                    LOG.log(Level.WARNING, null, ioe);
                }
            }
            this.annotations.put(profile, m);
        }
        this.pcs.firePropertyChange(PROP_ANNOTATION_COLORINGS, MimePath.EMPTY, profile);
    }

    @Override
    public Set<String> getKeyMapProfiles() {
        return ProfilesTracker.get("Keybindings", EDITORS_FOLDER).getProfilesDisplayNames();
    }

    @Override
    public boolean isCustomKeymapProfile(String profile) {
        ProfilesTracker tracker = ProfilesTracker.get("Keybindings", EDITORS_FOLDER);
        ProfilesTracker.ProfileDescription pd = tracker.getProfileByDisplayName(profile);
        return pd == null || !pd.isRollbackAllowed();
    }

    @Override
    public String getCurrentKeyMapProfile() {
        if (this.currentKeyMapProfile == null) {
            Object o;
            FileObject fo = FileUtil.getConfigFile((String)KEYMAPS_FOLDER);
            if (fo != null && (o = fo.getAttribute(FATTR_CURRENT_KEYMAP_PROFILE)) instanceof String) {
                this.currentKeyMapProfile = (String)o;
            }
            if (this.currentKeyMapProfile == null) {
                this.currentKeyMapProfile = DEFAULT_PROFILE;
            }
            this.tracker = new KeymapProfileTracker(fo);
        }
        return this.currentKeyMapProfile;
    }

    @Override
    public void setCurrentKeyMapProfile(String keyMapName) {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(propertyName, l);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(propertyName, l);
    }

    private EditorSettingsImpl() {
    }

    @Override
    public KeyBindingSettingsFactory getKeyBindingSettings(String[] mimeTypes) {
        mimeTypes = this.filter(mimeTypes);
        return KeyBindingSettingsImpl.get(Utils.mimeTypes2mimePath((String[])mimeTypes));
    }

    @Override
    public FontColorSettingsFactory getFontColorSettings(String[] mimeTypes) {
        mimeTypes = this.filter(mimeTypes);
        return FontColorSettingsImpl.get(Utils.mimeTypes2mimePath((String[])mimeTypes));
    }

    private String[] filter(String[] mimeTypes) {
        if (mimeTypes.length > 0) {
            String[] filtered = mimeTypes;
            if (mimeTypes[0].contains(TEXT_BASE_MIME_TYPE)) {
                if (mimeTypes.length == 1) {
                    filtered = EMPTY;
                } else {
                    filtered = new String[mimeTypes.length - 1];
                    System.arraycopy(mimeTypes, 1, filtered, 0, mimeTypes.length - 1);
                }
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.log(Level.INFO, "text/base has been deprecated, use MimePath.EMPTY instead.");
                }
            } else if (mimeTypes[0].startsWith("test")) {
                filtered = new String[mimeTypes.length];
                System.arraycopy(mimeTypes, 0, filtered, 0, mimeTypes.length);
                filtered[0] = mimeTypes[0].substring(mimeTypes[0].indexOf(95) + 1);
                LOG.log(Level.INFO, "Don't use 'test' mime type to access settings through the editor/settings/storage API!", new Throwable("Stacktrace"));
            }
            return filtered;
        }
        return mimeTypes;
    }

    private MimePath filter(MimePath mimePath) {
        if (mimePath.size() > 0) {
            MimePath filtered = mimePath;
            String first = mimePath.getMimeType(0);
            if (first.contains(TEXT_BASE_MIME_TYPE)) {
                if (mimePath.size() == 1) {
                    filtered = MimePath.EMPTY;
                } else {
                    String path = mimePath.getPath().substring(first.length() + 1);
                    filtered = MimePath.parse((String)path);
                }
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.log(Level.INFO, "text/base has been deprecated, use MimePath.EMPTY instead.");
                }
            } else if (first.startsWith("test")) {
                String filteredFirst = first.substring(first.indexOf(95) + 1);
                String path = filteredFirst + mimePath.getPath().substring(first.length() + 1);
                filtered = MimePath.parse((String)path);
                LOG.log(Level.INFO, "Don't use 'test' mime type to access settings through the editor/settings/storage API!", new Throwable("Stacktrace"));
            }
            return filtered;
        }
        return mimePath;
    }

    private class KeymapProfileTracker
    extends FileChangeAdapter {
        private FileObject keymapFolder;

        public KeymapProfileTracker(FileObject keymapFolder) {
            this.keymapFolder = keymapFolder;
            if (keymapFolder != null) {
                keymapFolder.addFileChangeListener((FileChangeListener)this);
            } else {
                FileUtil.getConfigRoot().addFileChangeListener((FileChangeListener)this);
            }
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
            if (EditorSettingsImpl.FATTR_CURRENT_KEYMAP_PROFILE.equals(fe.getName())) {
                Object n = fe.getNewValue();
                Object o = fe.getOldValue();
                String ov = o == null ? EditorSettingsImpl.DEFAULT_PROFILE : o.toString();
                String nv = n == null ? EditorSettingsImpl.DEFAULT_PROFILE : n.toString();
                EditorSettingsImpl.this.currentKeyMapProfile = nv;
                EditorSettingsImpl.this.pcs.firePropertyChange("currentKeyMapProfile", ov, nv);
            }
        }

        public synchronized void fileFolderCreated(FileEvent fe) {
            FileObject f = fe.getFile();
            if (this.keymapFolder == null && EditorSettingsImpl.KEYMAPS_FOLDER.equals(f.getNameExt()) && f.getParent() == FileUtil.getConfigRoot()) {
                this.keymapFolder = f;
                f.addFileChangeListener((FileChangeListener)this);
            }
        }
    }
}

