/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.Attributed;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;

public abstract class TypeDeclaration
extends Statement
implements Attributed {
    private Identifier name;
    private final ArrayList<Expression> interfaces = new ArrayList();
    private Block body;
    private final List<Attribute> attributes;

    public TypeDeclaration(int start, int end, Identifier name, Expression[] interfaces, Block body) {
        this(start, end, name, interfaces, body, Collections.emptyList());
    }

    public TypeDeclaration(int start, int end, Identifier name, Expression[] interfaces, Block body, List<Attribute> attributes) {
        super(start, end);
        if (name == null || body == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.body = body;
        if (interfaces != null) {
            this.interfaces.addAll(Arrays.asList(interfaces));
        }
        this.attributes = attributes;
    }

    public Block getBody() {
        return this.body;
    }

    public Identifier getName() {
        return this.name;
    }

    @Deprecated
    public List<Expression> getInterfaes() {
        return this.getInterfaces();
    }

    public List<Expression> getInterfaces() {
        return Collections.unmodifiableList(this.interfaces);
    }

    @Override
    public List<Attribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    @Override
    public boolean isAttributed() {
        return !this.attributes.isEmpty();
    }

    public String toString() {
        StringBuilder sbAttributes = new StringBuilder();
        this.getAttributes().forEach(attribute -> sbAttributes.append(attribute).append(" "));
        StringBuilder sb = new StringBuilder();
        for (Expression expression : this.getInterfaces()) {
            sb.append(expression).append(",");
        }
        return sbAttributes.toString() + String.valueOf(this.getName()) + (String)(sb.length() > 0 ? " " + sb.toString() : " ") + String.valueOf(this.getBody());
    }
}

