/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import org.bouncycastle.bcpg.HashUtils;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.OnePassSignaturePacket;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.sig.IssuerFingerprint;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.openpgp.PGPDefaultSignatureGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPContentSigner;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class PGPSignatureGenerator
extends PGPDefaultSignatureGenerator {
    private SignatureSubpacket[] unhashed = new SignatureSubpacket[0];
    private SignatureSubpacket[] hashed = new SignatureSubpacket[0];
    private PGPContentSignerBuilder contentSignerBuilder;
    private PGPContentSigner contentSigner;
    private int providedKeyAlgorithm = -1;
    private PGPPublicKey signingPubKey;
    private byte[] salt;

    public PGPSignatureGenerator(PGPContentSignerBuilder contentSignerBuilder) {
        this(contentSignerBuilder, 4);
    }

    PGPSignatureGenerator(PGPContentSignerBuilder contentSignerBuilder, int version) {
        super(version);
        this.contentSignerBuilder = contentSignerBuilder;
    }

    public PGPSignatureGenerator(PGPContentSignerBuilder contentSignerBuilder, PGPPublicKey signingKey) {
        this(contentSignerBuilder, signingKey, signingKey.getVersion());
    }

    public PGPSignatureGenerator(PGPContentSignerBuilder contentSignerBuilder, PGPPublicKey signingKey, int signatureVersion) {
        this(contentSignerBuilder, signatureVersion);
        this.signingPubKey = signingKey;
        if (signingKey.getVersion() == 6 && signatureVersion != 6) {
            throw new IllegalArgumentException("Version 6 keys MUST only generate version 6 signatures.");
        }
    }

    public void init(int signatureType, PGPPrivateKey key) throws PGPException {
        if (signatureType == 255) {
            throw new PGPException("Illegal signature type 0xFF provided.");
        }
        this.contentSigner = this.contentSignerBuilder.build(signatureType, key);
        this.sigOut = this.contentSigner.getOutputStream();
        this.sigType = this.contentSigner.getType();
        this.lastb = 0;
        if (this.providedKeyAlgorithm >= 0 && this.providedKeyAlgorithm != this.contentSigner.getKeyAlgorithm()) {
            throw new PGPException("key algorithm mismatch");
        }
        if (key.getPublicKeyPacket().getVersion() != this.version) {
            throw new PGPException("Key version mismatch.");
        }
        if (this.version == 6) {
            int saltSize = HashUtils.getV6SignatureSaltSizeInBytes(this.contentSigner.getHashAlgorithm());
            this.salt = new byte[saltSize];
            CryptoServicesRegistrar.getSecureRandom().nextBytes(this.salt);
            try {
                this.sigOut.write(this.salt);
            }
            catch (IOException e) {
                throw new PGPException("Cannot update signature with salt.");
            }
        }
    }

    public void setHashedSubpackets(PGPSignatureSubpacketVector hashedPcks) {
        if (hashedPcks == null) {
            this.hashed = new SignatureSubpacket[0];
            return;
        }
        this.hashed = hashedPcks.toSubpacketArray();
    }

    public void setUnhashedSubpackets(PGPSignatureSubpacketVector unhashedPcks) {
        if (unhashedPcks == null) {
            this.unhashed = new SignatureSubpacket[0];
            return;
        }
        this.unhashed = unhashedPcks.toSubpacketArray();
    }

    public PGPOnePassSignature generateOnePassVersion(boolean isNested) throws PGPException {
        if (this.version == 6) {
            return new PGPOnePassSignature(this.v6OPSPacket(isNested));
        }
        return new PGPOnePassSignature(this.v3OPSPacket(isNested));
    }

    private OnePassSignaturePacket v3OPSPacket(boolean isNested) {
        return new OnePassSignaturePacket(this.sigType, this.contentSigner.getHashAlgorithm(), this.contentSigner.getKeyAlgorithm(), this.contentSigner.getKeyID(), isNested);
    }

    private OnePassSignaturePacket v6OPSPacket(boolean isNested) {
        return new OnePassSignaturePacket(this.sigType, this.contentSigner.getHashAlgorithm(), this.contentSigner.getKeyAlgorithm(), this.salt, this.signingPubKey.getFingerprint(), isNested);
    }

    public PGPSignature generate() throws PGPException {
        MPInteger[] sigValues;
        this.prepareSignatureSubpackets();
        ByteArrayOutputStream sOut = new ByteArrayOutputStream();
        try {
            sOut.write((byte)this.version);
            sOut.write((byte)this.sigType);
            sOut.write((byte)this.contentSigner.getKeyAlgorithm());
            sOut.write((byte)this.contentSigner.getHashAlgorithm());
            ByteArrayOutputStream hOut = new ByteArrayOutputStream();
            for (int i = 0; i != this.hashed.length; ++i) {
                this.hashed[i].encode(hOut);
            }
            byte[] data = hOut.toByteArray();
            if (this.version == 6) {
                sOut.write((byte)(data.length >> 24));
                sOut.write((byte)(data.length >> 16));
            }
            sOut.write((byte)(data.length >> 8));
            sOut.write((byte)data.length);
            sOut.write(data);
            int dataLen = sOut.toByteArray().length;
            sOut.write((byte)this.version);
            sOut.write(-1);
            sOut.write((byte)(dataLen >> 24));
            sOut.write((byte)(dataLen >> 16));
            sOut.write((byte)(dataLen >> 8));
            sOut.write((byte)dataLen);
        }
        catch (IOException e) {
            throw new PGPException("exception encoding hashed data.", e);
        }
        byte[] trailer = sOut.toByteArray();
        this.blockUpdate(trailer, 0, trailer.length);
        switch (this.contentSigner.getKeyAlgorithm()) {
            case 1: 
            case 3: {
                sigValues = new MPInteger[]{new MPInteger(new BigInteger(1, this.contentSigner.getSignature()))};
                break;
            }
            case 22: {
                byte[] enc = this.contentSigner.getSignature();
                sigValues = new MPInteger[]{new MPInteger(new BigInteger(1, Arrays.copyOfRange((byte[])enc, (int)0, (int)(enc.length / 2)))), new MPInteger(new BigInteger(1, Arrays.copyOfRange((byte[])enc, (int)(enc.length / 2), (int)enc.length)))};
                break;
            }
            case 27: 
            case 28: {
                sigValues = null;
                break;
            }
            default: {
                sigValues = PGPUtil.dsaSigToMpi(this.contentSigner.getSignature());
            }
        }
        byte[] digest = this.contentSigner.getDigest();
        byte[] fingerPrint = new byte[]{digest[0], digest[1]};
        SignaturePacket sigPckt = sigValues != null ? new SignaturePacket(this.version, this.sigType, this.contentSigner.getKeyID(), this.contentSigner.getKeyAlgorithm(), this.contentSigner.getHashAlgorithm(), this.hashed, this.unhashed, fingerPrint, sigValues, this.salt) : new SignaturePacket(this.version, this.sigType, this.contentSigner.getKeyID(), this.contentSigner.getKeyAlgorithm(), this.contentSigner.getHashAlgorithm(), this.hashed, this.unhashed, fingerPrint, this.contentSigner.getSignature(), this.salt);
        return new PGPSignature(sigPckt);
    }

    protected void prepareSignatureSubpackets() throws PGPException {
        switch (this.version) {
            case 4: 
            case 5: {
                if (this.packetNotPresent(this.hashed, 2)) {
                    this.hashed = this.insertSubpacket(this.hashed, new SignatureCreationTime(true, new Date()));
                }
                if (!this.packetNotPresent(this.hashed, 16) || !this.packetNotPresent(this.unhashed, 16)) break;
                this.unhashed = this.insertSubpacket(this.unhashed, new IssuerKeyID(false, this.contentSigner.getKeyID()));
                break;
            }
            case 6: {
                if (this.packetNotPresent(this.hashed, 2)) {
                    this.hashed = this.insertSubpacket(this.hashed, new SignatureCreationTime(true, new Date()));
                }
                if (!this.packetNotPresent(this.hashed, 33) || !this.packetNotPresent(this.unhashed, 33) || this.signingPubKey == null) break;
                this.hashed = this.insertSubpacket(this.hashed, new IssuerFingerprint(true, this.version, this.signingPubKey.getFingerprint()));
            }
        }
    }

    public PGPSignature generateCertification(String id, PGPPublicKey pubKey) throws PGPException {
        this.updateWithPublicKey(pubKey);
        this.updateWithIdData(180, Strings.toUTF8ByteArray((String)id));
        return this.generate();
    }

    public PGPSignature generateCertification(PGPUserAttributeSubpacketVector userAttributes, PGPPublicKey pubKey) throws PGPException {
        this.updateWithPublicKey(pubKey);
        this.getAttributesHash(userAttributes);
        return this.generate();
    }

    public PGPSignature generateCertification(PGPPublicKey masterKey, PGPPublicKey pubKey) throws PGPException {
        this.updateWithPublicKey(masterKey);
        this.updateWithPublicKey(pubKey);
        return this.generate();
    }

    public PGPSignature generateCertification(PGPPublicKey pubKey) throws PGPException {
        if (!(this.sigType != 40 && this.sigType != 24 || pubKey.isMasterKey())) {
            throw new IllegalArgumentException("certifications involving subkey requires public key of revoking key as well.");
        }
        this.updateWithPublicKey(pubKey);
        return this.generate();
    }

    private boolean packetNotPresent(SignatureSubpacket[] packets, int type) {
        for (int i = 0; i != packets.length; ++i) {
            if (packets[i].getType() != type) continue;
            return false;
        }
        return true;
    }

    private SignatureSubpacket[] insertSubpacket(SignatureSubpacket[] packets, SignatureSubpacket subpacket) {
        SignatureSubpacket[] tmp = new SignatureSubpacket[packets.length + 1];
        tmp[0] = subpacket;
        System.arraycopy(packets, 0, tmp, 1, packets.length);
        return tmp;
    }
}

