/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\u001aD\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00032\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\f\u001a\u00020\r\u001a6\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\u00032\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\u00032\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"logger", "Lorg/apache/logging/log4j/Logger;", "distributeShards", "", "", "", "Lorg/opensearch/core/index/shard/ShardId;", "maxFanoutNodes", "", "allNodes", "", "shards", "index", "Lorg/opensearch/core/index/Index;", "initializeNewLastRunContext", "", "lastRunContext", "shardCount", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nMonitorFanOutUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonitorFanOutUtils.kt\norg/opensearch/alerting/MonitorFanOutUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1549#2:81\n1620#2,3:82\n1271#2,2:85\n1285#2,4:87\n1864#2,3:91\n*S KotlinDebug\n*F\n+ 1 MonitorFanOutUtils.kt\norg/opensearch/alerting/MonitorFanOutUtilsKt\n*L\n25#1:81\n25#1:82,3\n31#1:85,2\n31#1:87,4\n38#1:91,3\n*E\n"})
public final class MonitorFanOutUtilsKt {
    @NotNull
    private static final Logger logger;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, Set<ShardId>> distributeShards(int maxFanoutNodes, @NotNull List<String> allNodes, @NotNull List<String> shards, @NotNull Index index) {
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(allNodes, (String)"allNodes");
        Intrinsics.checkNotNullParameter(shards, (String)"shards");
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        int totalShards = shards.size();
        int numFanOutNodes = RangesKt.coerceAtMost((int)allNodes.size(), (int)totalShards);
        int totalNodes = RangesKt.coerceAtMost((int)maxFanoutNodes, (int)numFanOutNodes);
        Iterable $this$map$iv = shards;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(new ShardId(index, Integer.parseInt((String)it)));
        }
        List shardIdList = (List)destination$iv$iv;
        List shuffledNodes = CollectionsKt.shuffled((Iterable)allNodes);
        List nodes = shuffledNodes.subList(0, totalNodes);
        Iterable $this$associateWith$iv = nodes;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            String string = (String)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            Set set = new LinkedHashSet();
            object.put(t, set);
        }
        Map nodeShardAssignments = result$iv;
        if (nodeShardAssignments.isEmpty()) {
            logger.error("No nodes eligible for fanout");
            return nodeShardAssignments;
        }
        Iterable $this$forEachIndexed$iv = shardIdList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void shardId;
            int n;
            Object element$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv = (ShardId)item$iv;
            int idx = n;
            boolean bl = false;
            int nodeIdx = idx % nodes.size();
            String node = (String)nodes.get(nodeIdx);
            Object v = nodeShardAssignments.get(node);
            Intrinsics.checkNotNull(v);
            ((Set)v).add(shardId);
        }
        return nodeShardAssignments;
    }

    @NotNull
    public static final Map<String, Object> initializeNewLastRunContext(@NotNull Map<String, ? extends Object> lastRunContext, @NotNull String index, int shardCount) {
        Intrinsics.checkNotNullParameter(lastRunContext, (String)"lastRunContext");
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Map updatedLastRunContext = MapsKt.toMutableMap(lastRunContext);
        for (int i = 0; i < shardCount; ++i) {
            String shard = String.valueOf(i);
            if (updatedLastRunContext.containsKey(shard)) continue;
            updatedLastRunContext.put(shard, -2L);
        }
        Integer n = shardCount;
        updatedLastRunContext.put("shards_count", n);
        updatedLastRunContext.put("index", index);
        return updatedLastRunContext;
    }

    static {
        Logger logger = LogManager.getLogger((String)"FanOutEligibility");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        MonitorFanOutUtilsKt.logger = logger;
    }
}

