function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React, { useEffect } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { EuiHeaderSectionItem, EuiHeaderSection } from './header_section';
import { EuiHeaderBreadcrumbs } from './header_breadcrumbs';
function createHeaderSection(sections, border) {
  return sections.map(function (section, index) {
    return /*#__PURE__*/React.createElement(EuiHeaderSectionItem, {
      key: index,
      border: border
    }, section);
  });
}
// Start a counter to manage the total number of fixed headers that need the body class
var euiHeaderFixedCounter = 0;
export var EuiHeader = function EuiHeader(_ref) {
  var children = _ref.children,
    className = _ref.className,
    sections = _ref.sections,
    _ref$position = _ref.position,
    position = _ref$position === void 0 ? 'static' : _ref$position,
    _ref$theme = _ref.theme,
    theme = _ref$theme === void 0 ? 'default' : _ref$theme,
    rest = _objectWithoutProperties(_ref, ["children", "className", "sections", "position", "theme"]);
  var classes = classNames('euiHeader', "euiHeader--".concat(theme), "euiHeader--".concat(position), className);
  useEffect(function () {
    if (position === 'fixed') {
      // Increment fixed header counter for each fixed header
      euiHeaderFixedCounter++;
      document.body.classList.add('euiBody--headerIsFixed');
      return function () {
        // Both decrement the fixed counter AND then check if there are none
        if (--euiHeaderFixedCounter === 0) {
          // If there are none, THEN remove class
          document.body.classList.remove('euiBody--headerIsFixed');
        }
      };
    }
  }, [position]);
  var contents;
  if (sections) {
    if (children) {
      // In case both children and sections are passed, warn in the console that the children will be disregarded
      console.warn('EuiHeader cannot accept both `children` and `sections`. It will disregard the `children`.');
    }
    contents = sections.map(function (section, index) {
      var content = [];
      if (section.items) {
        // Items get wrapped in EuiHeaderSection and each item in a EuiHeaderSectionItem
        content.push(/*#__PURE__*/React.createElement(EuiHeaderSection, {
          key: "items-".concat(index)
        }, createHeaderSection(section.items, section.borders)));
      }
      if (section.breadcrumbs) {
        content.push(
        /*#__PURE__*/
        // Breadcrumbs are separate and cannot be contained in a EuiHeaderSection
        // in order for truncation to work
        React.createElement(EuiHeaderBreadcrumbs, _extends({
          key: "breadcrumbs-".concat(index),
          breadcrumbs: section.breadcrumbs
        }, section.breadcrumbProps)));
      }
      return content;
    });
  } else {
    contents = children;
  }
  return /*#__PURE__*/React.createElement("div", _extends({
    className: classes
  }, rest), contents);
};
EuiHeader.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  /**
       * An array of objects to wrap in a #EuiHeaderSection.
       * Each section is spaced using `space-between`.
       * See #EuiHeaderSectionsProp for object details.
       * This prop disregards the prop `children` if both are passed.
       */
  sections: PropTypes.arrayOf(PropTypes.shape({
    /**
       * An arry of items that will be wrapped in a #EuiHeaderSectionItem
       */
    items: PropTypes.arrayOf(PropTypes.node.isRequired),
    /**
       * Apply the passed border side to each #EuiHeaderSectionItem
       */
    borders: PropTypes.oneOf(["left", "right", "none"]),
    /**
       * Breadcrumbs in the header cannot be wrapped in a #EuiHeaderSection in order for truncation to work.
       * Simply pass the array of EuiBreadcrumb objects
       */
    breadcrumbs: PropTypes.arrayOf(PropTypes.shape({
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string,
      /**
         * Visible label of the breadcrumb
         */
      text: PropTypes.node.isRequired,
      href: PropTypes.string,
      onClick: PropTypes.func,
      /**
         * Force a max-width on the breadcrumb text
         */
      truncate: PropTypes.bool
    }).isRequired),
    /**
       * Other props to pass to #EuiHeaderBreadcrumbs
       */
    breadcrumbProps: PropTypes.any
  }).isRequired),
  /**
       * Helper that positions the header against the window body and
       * adds the correct amount of top padding to the window when in `fixed` mode
       */
  position: PropTypes.oneOf(["static", "fixed"]),
  /**
       * The `default` will inherit its coloring from the light or dark theme.
       * Or, force the header into pseudo `dark` theme for all themes.
       */
  theme: PropTypes.oneOf(["default", "dark"])
};