"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCompressedRadioGroup = exports.EuiRadioGroup = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _form_fieldset = require("../form_fieldset");
var _radio = require("./radio");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// Must omit inherit `onChange` properties or else TS complains when applying to the EuiRadio

var EuiRadioGroup = function EuiRadioGroup(_ref) {
  var _ref$options = _ref.options,
    options = _ref$options === void 0 ? [] : _ref$options,
    idSelected = _ref.idSelected,
    onChange = _ref.onChange,
    name = _ref.name,
    className = _ref.className,
    disabled = _ref.disabled,
    compressed = _ref.compressed,
    legend = _ref.legend,
    rest = _objectWithoutProperties(_ref, ["options", "idSelected", "onChange", "name", "className", "disabled", "compressed", "legend"]);
  var radios = options.map(function (option, index) {
    var isOptionDisabled = option.disabled,
      optionClass = option.className,
      id = option.id,
      label = option.label,
      optionRest = _objectWithoutProperties(option, ["disabled", "className", "id", "label"]);
    return /*#__PURE__*/_react.default.createElement(_radio.EuiRadio, _extends({
      className: (0, _classnames.default)('euiRadioGroup__item', optionClass),
      key: index,
      name: name,
      checked: id === idSelected,
      disabled: disabled || isOptionDisabled,
      onChange: onChange.bind(null, id, option.value),
      compressed: compressed,
      id: id,
      label: label
    }, optionRest));
  });
  if (!!legend) {
    // Be sure to pass down the compressed option to the legend
    legend.compressed = compressed;
    return /*#__PURE__*/_react.default.createElement(_form_fieldset.EuiFormFieldset, _extends({
      className: className,
      legend: legend
    }, rest), radios);
  }
  return /*#__PURE__*/_react.default.createElement("div", _extends({
    className: className
  }, rest), radios);
};

// @internal
exports.EuiRadioGroup = EuiRadioGroup;
EuiRadioGroup.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  disabled: _propTypes.default.bool,
  /**
     * Tightens up the spacing between radio rows and sends down the
     * compressed prop to the radio itself
     */
  compressed: _propTypes.default.bool,
  name: _propTypes.default.string,
  options: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string.isRequired
  }).isRequired).isRequired,
  idSelected: _propTypes.default.string,
  onChange: _propTypes.default.func.isRequired,
  /**
     * If the individual labels for each radio do not provide a sufficient description, add a legend.
     * Wraps the group in a `EuiFormFieldset` which adds an `EuiLegend` for titling the whole group.
     * Accepts an `EuiFormLegendProps` shape.
     */
  legend: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    /**
         * ReactNode to render as this component's content
         */
    children: _propTypes.default.node.isRequired,
    /**
         * For a hidden legend that is still visible to the screen reader, set to 'hidden'
         */
    display: _propTypes.default.oneOf(["hidden", "visible"]),
    compressed: _propTypes.default.bool
  })
};
// @internal
var EuiCompressedRadioGroup = function EuiCompressedRadioGroup(props) {
  return /*#__PURE__*/_react.default.createElement(EuiRadioGroup, _extends({}, props, {
    compressed: true
  }));
};
exports.EuiCompressedRadioGroup = EuiCompressedRadioGroup;
EuiCompressedRadioGroup.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  disabled: _propTypes.default.bool,
  name: _propTypes.default.string,
  options: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string.isRequired
  }).isRequired).isRequired,
  idSelected: _propTypes.default.string,
  onChange: _propTypes.default.func.isRequired,
  /**
     * If the individual labels for each radio do not provide a sufficient description, add a legend.
     * Wraps the group in a `EuiFormFieldset` which adds an `EuiLegend` for titling the whole group.
     * Accepts an `EuiFormLegendProps` shape.
     */
  legend: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    children: _propTypes.default.node.isRequired,
    display: _propTypes.default.oneOf(["hidden", "visible"]),
    compressed: _propTypes.default.bool
  })
};