"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiRangeTicks", {
  enumerable: true,
  get: function get() {
    return _range_ticks.EuiRangeTicks;
  }
});
exports.OuiRangeTicks = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _utils = require("./utils");
var _inner_text = require("../../inner_text");
var _range_ticks = require("../../../eui_components/form/range/range_ticks");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

var OuiTickValue = function OuiTickValue(_ref) {
  var disabled = _ref.disabled,
    customTicks = _ref.ticks,
    min = _ref.min,
    max = _ref.max,
    value = _ref.value,
    onChange = _ref.onChange,
    percentageWidth = _ref.percentageWidth,
    tickValue = _ref.tickValue,
    ticksRef = _ref.ticksRef;
  var tickStyle = {};
  var tickObject = customTicks ? customTicks.find(function (o) {
    return o.value === tickValue;
  }) : {
    value: tickValue,
    label: tickValue
  };
  var isMinTick = (tickObject === null || tickObject === void 0 ? void 0 : tickObject.value) === min;
  var isMaxTick = (tickObject === null || tickObject === void 0 ? void 0 : tickObject.value) === max;
  var label = tickObject ? tickObject.label : tickValue;

  // Math worked out by trial and error
  // Shifts the label into the reserved margin of OuiRangeTrack
  var labelShiftVal = (isMinTick || isMaxTick) && label.length > 3 ? Math.min(label.length * 0.25, 1.25) : 0;
  if (isMaxTick && !!labelShiftVal) {
    tickStyle.right = '0%';
  } else {
    var _ticksRef$current$cli, _ticksRef$current;
    var trackWidth = (_ticksRef$current$cli = (_ticksRef$current = ticksRef.current) === null || _ticksRef$current === void 0 ? void 0 : _ticksRef$current.clientWidth) !== null && _ticksRef$current$cli !== void 0 ? _ticksRef$current$cli : 0;
    var position = (0, _utils.calculateThumbPosition)(tickValue, min, max, trackWidth);
    var thumbOffset = labelShiftVal ? 0 : _utils.OUI_THUMB_SIZE / 2;
    tickStyle.left = "calc(".concat(position, "% + ").concat(thumbOffset, "px)");
  }
  tickStyle.maxWidth = customTicks ? undefined : "".concat(percentageWidth, "%");
  var pseudoShift = {};
  if (labelShiftVal) {
    var labelShift = isMaxTick ? 'marginRight' : 'marginLeft';
    tickStyle[labelShift] = "-".concat(labelShiftVal, "em");
    pseudoShift[labelShift] = "calc(".concat(labelShiftVal, "em + 4px)"); // 4px derived from .ouiRangeTicks left/right offset
  }
  var pseudoTick = tickObject && !!labelShiftVal && (isMinTick || isMaxTick);
  var tickClasses = (0, _classnames.default)('ouiRangeTick', {
    'ouiRangeTick--selected': value === tickValue,
    'ouiRangeTick--isCustom': customTicks,
    'ouiRangeTick--isMin': labelShiftVal && isMinTick,
    'ouiRangeTick--isMax': labelShiftVal && isMaxTick,
    'ouiRangeTick--hasTickMark': pseudoTick
  });
  var _useInnerText = (0, _inner_text.useInnerText)(),
    _useInnerText2 = (0, _slicedToArray2.default)(_useInnerText, 2),
    ref = _useInnerText2[0],
    innerText = _useInnerText2[1];
  return /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    className: tickClasses,
    value: tickValue,
    disabled: disabled,
    onClick: onChange,
    style: tickStyle,
    tabIndex: -1,
    ref: ref,
    title: typeof label === 'string' ? label : innerText
  }, pseudoTick && /*#__PURE__*/_react.default.createElement("span", {
    className: "ouiRangeTick__pseudo",
    "aria-hidden": true,
    style: pseudoShift
  }), label);
};
OuiTickValue.propTypes = {
  ticks: _propTypes.default.arrayOf(_propTypes.default.shape({
    value: _propTypes.default.number.isRequired,
    label: _propTypes.default.node.isRequired
  }).isRequired),
  tickSequence: _propTypes.default.arrayOf(_propTypes.default.number.isRequired).isRequired,
  value: _propTypes.default.oneOfType([_propTypes.default.number.isRequired, _propTypes.default.string.isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]).isRequired).isRequired]),
  min: _propTypes.default.number.isRequired,
  max: _propTypes.default.number.isRequired,
  compressed: _propTypes.default.bool,
  interval: _propTypes.default.number,
  disabled: _propTypes.default.bool,
  onChange: _propTypes.default.func,
  ticksRef: _propTypes.default.any.isRequired,
  tickValue: _propTypes.default.any.isRequired,
  percentageWidth: _propTypes.default.number.isRequired
};
var OuiRangeTicks = function OuiRangeTicks(props) {
  var ticks = props.ticks,
    tickSequence = props.tickSequence,
    max = props.max,
    min = props.min,
    _props$interval = props.interval,
    interval = _props$interval === void 0 ? 1 : _props$interval,
    compressed = props.compressed;
  var ticksRef = _react.default.useRef(null);
  // Calculate the width of each tick mark
  var percentageWidth = interval / (max - min + interval) * 100;
  var classes = (0, _classnames.default)('ouiRangeTicks', {
    'ouiRangeTicks--compressed': compressed,
    'ouiRangeTicks--isCustom': ticks
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    className: classes,
    ref: ticksRef
  }, tickSequence.map(function (tickValue) {
    return /*#__PURE__*/_react.default.createElement(OuiTickValue, (0, _extends2.default)({
      key: tickValue
    }, props, {
      percentageWidth: percentageWidth,
      tickValue: tickValue,
      ticksRef: ticksRef
    }));
  }));
};

/* OUI -> EUI Aliases: Build-Time */
exports.OuiRangeTicks = OuiRangeTicks;
OuiRangeTicks.propTypes = {
  ticks: _propTypes.default.arrayOf(_propTypes.default.shape({
    value: _propTypes.default.number.isRequired,
    label: _propTypes.default.node.isRequired
  }).isRequired),
  tickSequence: _propTypes.default.arrayOf(_propTypes.default.number.isRequired).isRequired,
  value: _propTypes.default.oneOfType([_propTypes.default.number.isRequired, _propTypes.default.string.isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]).isRequired).isRequired]),
  min: _propTypes.default.number.isRequired,
  max: _propTypes.default.number.isRequired,
  compressed: _propTypes.default.bool,
  interval: _propTypes.default.number,
  disabled: _propTypes.default.bool,
  onChange: _propTypes.default.func
};
/* OUI -> EUI Aliases: Build-Time */