"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ExplorePluginSetup", {
  enumerable: true,
  get: function () {
    return _types.ExplorePluginSetup;
  }
});
Object.defineProperty(exports, "ExplorePluginStart", {
  enumerable: true,
  get: function () {
    return _types.ExplorePluginStart;
  }
});
exports.config = void 0;
exports.plugin = plugin;
var _config = require("../common/config");
var _plugin = require("./plugin");
var _types = require("./types");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function plugin(initializerContext) {
  return new _plugin.ExplorePlugin(initializerContext);
}
const config = exports.config = {
  exposeToBrowser: {
    enabled: true
  },
  schema: _config.configSchema,
  deprecations: ({
    rename,
    unused
  }) => [
  // This is to ensure that when explore is enabled, the necessary settings for the enhanced experience are also enabled;
  // this is a short-term solution that utilizes the deprecation framework to modify settings while typical deprecation functionality in OSD is not designed for this purpose.
  (settings, fromPath, addDeprecation) => {
    var _settings$explore;
    if ((settings === null || settings === void 0 || (_settings$explore = settings.explore) === null || _settings$explore === void 0 ? void 0 : _settings$explore.enabled) === true) {
      settings.data = settings.data || {};
      settings.data.savedQueriesNewUI = settings.data.savedQueriesNewUI || {};
      settings.data.savedQueriesNewUI.enabled = true;
      settings.opensearchDashboards = settings.opensearchDashboards || {};
      settings.opensearchDashboards.branding = settings.opensearchDashboards.branding || {};
      settings.opensearchDashboards.branding.useExpandedHeader = false;
      settings.uiSettings = settings.uiSettings || {};
      settings.uiSettings.overrides = {
        ...(settings.uiSettings.overrides || {}),
        'theme:version': 'v9',
        'home:useNewHomePage': true,
        'query:enhancements:enabled': true
      };
    }
    return settings;
  }]
};