"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addBackticksIfNeeded = addBackticksIfNeeded;
exports.basePathLink = void 0;
exports.combineSchemaAndDatarows = combineSchemaAndDatarows;
exports.dataSourceFilterFn = void 0;
exports.get = get;
var _semver = _interopRequireDefault(require("semver"));
var pluginManifest = _interopRequireWildcard(require("../../opensearch_dashboards.json"));
var _core_refs = require("../../public/framework/core_refs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * TODO making this method type-safe is nontrivial: if you just define
 * `Nested<T> = { [k: string]: Nested<T> | T }` then you can't accumulate because `T` is not `Nested<T>`
 * There might be a way to define a recursive type that accumulates cleanly but it's probably not
 * worth the effort.
 */
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function get(obj, path, defaultValue) {
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  return path.split('.').reduce((acc, part) => acc && acc[part], obj) || defaultValue;
}
function addBackticksIfNeeded(input) {
  if (input === undefined) {
    return '';
  }
  // Check if the string already has backticks
  if (input.startsWith('`') && input.endsWith('`')) {
    return input; // Return the string as it is
  } else {
    // Add backticks to the string
    return '`' + input + '`';
  }
}
function combineSchemaAndDatarows(schema, datarows) {
  const combinedData = [];
  datarows.forEach(row => {
    const rowData = {};
    schema.forEach((field, index) => {
      rowData[field.name] = row[index];
    });
    combinedData.push(rowData);
  });
  return combinedData;
}

/**
 * Safely prepend the `basePath` from `coreRefs` to the given link.
 * If `coreRefs.http.basePath` exists (always true in normal operation), prepend it to the link.
 * If it doesn't exist (usually during unit testing), return the link as-is.
 *
 * @param link The link to prepend with `coreRefs.http.basePath`.
 * @returns The link with the prepended `basePath` if it exists, otherwise the unmodified link.
 */
const basePathLink = link => {
  var _coreRefs$http;
  if ((_coreRefs$http = _core_refs.coreRefs.http) !== null && _coreRefs$http !== void 0 && _coreRefs$http.basePath) {
    return _core_refs.coreRefs.http.basePath.prepend(link);
  } else {
    return link;
  }
};
exports.basePathLink = basePathLink;
const dataSourceFilterFn = dataSource => {
  var _dataSource$attribute, _dataSource$attribute2;
  const dataSourceVersion = (dataSource === null || dataSource === void 0 || (_dataSource$attribute = dataSource.attributes) === null || _dataSource$attribute === void 0 ? void 0 : _dataSource$attribute.dataSourceVersion) || '';
  const installedPlugins = (dataSource === null || dataSource === void 0 || (_dataSource$attribute2 = dataSource.attributes) === null || _dataSource$attribute2 === void 0 ? void 0 : _dataSource$attribute2.installedPlugins) || [];
  return _semver.default.satisfies(dataSourceVersion, pluginManifest.supportedOSDataSourceVersions) && pluginManifest.requiredOSDataSourcePlugins.every(plugin => installedPlugins.includes(plugin));
};
exports.dataSourceFilterFn = dataSourceFilterFn;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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