/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.runtime.ArraySchema;
import io.protostuff.runtime.ArraySchemas;
import io.protostuff.runtime.ClassSchema;
import io.protostuff.runtime.IdStrategy;
import io.protostuff.runtime.NumberSchema;
import io.protostuff.runtime.ObjectSchema;
import io.protostuff.runtime.PolymorphicCollectionSchema;
import io.protostuff.runtime.PolymorphicEnumSchema;
import io.protostuff.runtime.PolymorphicMapSchema;
import io.protostuff.runtime.PolymorphicPojoCollectionSchema;
import io.protostuff.runtime.PolymorphicPojoMapSchema;
import io.protostuff.runtime.PolymorphicPojoSchema;
import io.protostuff.runtime.PolymorphicSchema;
import io.protostuff.runtime.PolymorphicThrowableSchema;
import io.protostuff.runtime.RuntimeFieldFactory;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;

public enum PolymorphicSchemaFactories implements PolymorphicSchema.Factory
{
    ARRAY{

        @Override
        public PolymorphicSchema newSchema(Class<?> typeClass, IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            Class<?> ct = typeClass.getComponentType();
            RuntimeFieldFactory<?> rff = RuntimeFieldFactory.getFieldFactory(ct, strategy);
            if (rff == RuntimeFieldFactory.DELEGATE) {
                return strategy.getDelegateWrapper(ct).newSchema(typeClass, strategy, handler);
            }
            if (rff.id > 0 && rff.id < 15) {
                return ArraySchemas.newSchema(rff.id, ct, typeClass, strategy, handler);
            }
            if (ct.isEnum()) {
                return strategy.getEnumIO(ct).newSchema(typeClass, strategy, handler);
            }
            if (rff == RuntimeFieldFactory.POJO || rff == RuntimeFieldFactory.POLYMORPHIC_POJO && RuntimeFieldFactory.pojo(ct, null, strategy)) {
                return strategy.getSchemaWrapper(ct, true).newSchema(typeClass, strategy, handler);
            }
            return new ArraySchema(strategy){

                @Override
                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    }
    ,
    NUMBER{

        @Override
        public PolymorphicSchema newSchema(Class<?> typeClass, IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new NumberSchema(strategy){

                @Override
                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    }
    ,
    CLASS{

        @Override
        public PolymorphicSchema newSchema(Class<?> typeClass, IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new ClassSchema(strategy){

                @Override
                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    }
    ,
    ENUM{

        @Override
        public PolymorphicSchema newSchema(Class<?> typeClass, IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new PolymorphicEnumSchema(strategy){

                @Override
                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    }
    ,
    COLLECTION{

        @Override
        public PolymorphicSchema newSchema(Class<?> typeClass, IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new PolymorphicCollectionSchema(strategy){

                @Override
                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    }
    ,
    MAP{

        @Override
        public PolymorphicSchema newSchema(Class<?> typeClass, IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new PolymorphicMapSchema(strategy){

                @Override
                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    }
    ,
    THROWABLE{

        @Override
        public PolymorphicSchema newSchema(Class<?> typeClass, IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new PolymorphicThrowableSchema(strategy){

                @Override
                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    }
    ,
    POJO{

        @Override
        public PolymorphicSchema newSchema(Class<?> typeClass, IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new PolymorphicPojoSchema(strategy){

                @Override
                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    }
    ,
    POJO_MAP{

        @Override
        public PolymorphicSchema newSchema(Class<?> typeClass, IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new PolymorphicPojoMapSchema(strategy){

                @Override
                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    }
    ,
    POJO_COLLECTION{

        @Override
        public PolymorphicSchema newSchema(Class<?> typeClass, IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new PolymorphicPojoCollectionSchema(strategy){

                @Override
                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    }
    ,
    OBJECT{

        @Override
        public PolymorphicSchema newSchema(Class<?> typeClass, IdStrategy strategy, final PolymorphicSchema.Handler handler) {
            return new ObjectSchema(strategy){

                @Override
                protected void setValue(Object value, Object owner) {
                    handler.setValue(value, owner);
                }
            };
        }
    };


    public static PolymorphicSchema.Factory getFactoryFromField(Field f, IdStrategy strategy) {
        Class<?> clazz = f.getType();
        if (clazz.isArray()) {
            return ARRAY;
        }
        if (Number.class == clazz) {
            return NUMBER;
        }
        if (Class.class == clazz) {
            return CLASS;
        }
        if (Enum.class == clazz) {
            return ENUM;
        }
        if (Throwable.class.isAssignableFrom(clazz)) {
            return THROWABLE;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return 0 != (0x100 & strategy.flags) ? POJO_MAP : MAP;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return 0 != (0x80 & strategy.flags) ? POJO_COLLECTION : COLLECTION;
        }
        return OBJECT;
    }

    public static PolymorphicSchema.Factory getFactoryFromRepeatedValueGenericType(Class<?> clazz) {
        if (clazz.isArray()) {
            return ARRAY;
        }
        if (Number.class == clazz) {
            return NUMBER;
        }
        if (Class.class == clazz) {
            return CLASS;
        }
        if (Enum.class == clazz) {
            return ENUM;
        }
        if (Object.class == clazz) {
            return OBJECT;
        }
        if (Throwable.class.isAssignableFrom(clazz)) {
            return THROWABLE;
        }
        return null;
    }

    public static PolymorphicSchema getSchemaFromCollectionOrMapGenericType(Class<?> clazz, IdStrategy strategy) {
        if (clazz.isArray()) {
            Class<?> ct = clazz.getComponentType();
            RuntimeFieldFactory<?> rff = RuntimeFieldFactory.getFieldFactory(ct, strategy);
            if (rff == RuntimeFieldFactory.DELEGATE) {
                return strategy.getDelegateWrapper(ct).genericElementSchema;
            }
            if (rff.id > 0 && rff.id < 15) {
                return ArraySchemas.getGenericElementSchema(rff.id, strategy);
            }
            if (ct.isEnum()) {
                return strategy.getEnumIO(ct).genericElementSchema;
            }
            if (rff == RuntimeFieldFactory.POJO || rff == RuntimeFieldFactory.POLYMORPHIC_POJO && RuntimeFieldFactory.pojo(ct, null, strategy)) {
                return strategy.getSchemaWrapper(ct, (boolean)true).genericElementSchema;
            }
            return strategy.ARRAY_ELEMENT_SCHEMA;
        }
        if (Number.class == clazz) {
            return strategy.NUMBER_ELEMENT_SCHEMA;
        }
        if (Class.class == clazz) {
            return strategy.CLASS_ELEMENT_SCHEMA;
        }
        if (Enum.class == clazz) {
            return strategy.POLYMORPHIC_ENUM_ELEMENT_SCHEMA;
        }
        if (Object.class == clazz) {
            return strategy.OBJECT_ELEMENT_SCHEMA;
        }
        if (Throwable.class.isAssignableFrom(clazz)) {
            return strategy.POLYMORPHIC_THROWABLE_ELEMENT_SCHEMA;
        }
        return null;
    }
}

