/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.evaluation;

import java.util.ArrayList;
import java.util.List;
import org.tribuo.DataSource;
import org.tribuo.Dataset;
import org.tribuo.Example;
import org.tribuo.Model;
import org.tribuo.Output;
import org.tribuo.Prediction;
import org.tribuo.evaluation.Evaluation;
import org.tribuo.evaluation.OnlineEvaluator;
import org.tribuo.impl.ArrayExample;
import org.tribuo.provenance.DataProvenance;

public interface Evaluator<T extends Output<T>, E extends Evaluation<T>> {
    public E evaluate(Model<T> var1, Dataset<T> var2);

    public E evaluate(Model<T> var1, DataSource<T> var2);

    public E evaluate(Model<T> var1, List<Prediction<T>> var2, DataProvenance var3);

    default public E evaluate(Model<T> model, List<Prediction<T>> predictions, List<T> groundTruth, DataProvenance dataProvenance) {
        if (predictions.size() != groundTruth.size()) {
            throw new IllegalArgumentException("Predictions and ground truth must be the same length, received predictions.size()=" + predictions.size() + ", groundTruth.size()=" + groundTruth.size());
        }
        ArrayList<Prediction<T>> newPredictions = new ArrayList<Prediction<T>>(predictions.size());
        for (int i = 0; i < predictions.size(); ++i) {
            Prediction<T> curPrediction = predictions.get(i);
            Example<T> curExample = curPrediction.getExample();
            ArrayExample<Output> newExample = new ArrayExample<Output>((Output)groundTruth.get(i), curExample, curExample.getWeight());
            Prediction<Output> newPrediction = new Prediction<Output>(curPrediction, curPrediction.getNumActiveFeatures(), newExample);
            newPredictions.add(newPrediction);
        }
        return this.evaluate(model, newPredictions, dataProvenance);
    }

    default public OnlineEvaluator<T, E> createOnlineEvaluator(Model<T> model, DataProvenance provenance) {
        return new OnlineEvaluator(this, model, provenance);
    }
}

