/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.mappingtransformer;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.index.mapper.MappingTransformer;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLModel;
import org.opensearch.neuralsearch.mappingtransformer.SemanticInfoConfigBuilder;
import org.opensearch.neuralsearch.ml.MLCommonsClientAccessor;
import org.opensearch.neuralsearch.util.SemanticMappingUtils;

public class SemanticMappingTransformer
implements MappingTransformer {
    public static final Set<String> SUPPORTED_MODEL_ALGORITHMS = Set.of(FunctionName.TEXT_EMBEDDING.name(), FunctionName.REMOTE.name(), FunctionName.SPARSE_ENCODING.name(), FunctionName.SPARSE_TOKENIZE.name());
    public static final Set<String> SUPPORTED_REMOTE_MODEL_TYPES = Set.of(FunctionName.TEXT_EMBEDDING.name(), FunctionName.SPARSE_ENCODING.name(), FunctionName.SPARSE_TOKENIZE.name());
    private final MLCommonsClientAccessor mlClientAccessor;
    private final NamedXContentRegistry xContentRegistry;

    public SemanticMappingTransformer(MLCommonsClientAccessor mlClientAccessor, NamedXContentRegistry xContentRegistry) {
        this.mlClientAccessor = mlClientAccessor;
        this.xContentRegistry = xContentRegistry;
    }

    public void transform(Map<String, Object> mapping, MappingTransformer.TransformContext context, @NonNull ActionListener<Void> listener) {
        Objects.requireNonNull(listener, "listener is marked non-null but is null");
        try {
            Map<String, Object> properties = SemanticMappingUtils.getProperties(mapping);
            if (properties.isEmpty()) {
                listener.onResponse(null);
                return;
            }
            HashMap<String, Map<String, Object>> semanticFieldPathToConfigMap = new HashMap<String, Map<String, Object>>();
            SemanticMappingUtils.collectSemanticField(properties, semanticFieldPathToConfigMap);
            this.validateSemanticFields(semanticFieldPathToConfigMap);
            this.fetchModelAndModifyMapping(semanticFieldPathToConfigMap, properties, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void validateSemanticFields(@NonNull Map<String, Map<String, Object>> semanticFieldPathToConfigMap) {
        Objects.requireNonNull(semanticFieldPathToConfigMap, "semanticFieldPathToConfigMap is marked non-null but is null");
        ArrayList<String> errors = new ArrayList<String>();
        for (Map.Entry<String, Map<String, Object>> entry : semanticFieldPathToConfigMap.entrySet()) {
            String semanticFieldPath = entry.getKey();
            Map<String, Object> semanticFieldConfig = entry.getValue();
            String validateModelIdError = SemanticMappingUtils.validateModelId(semanticFieldPath, semanticFieldConfig);
            String validateSemanticInfoFieldNameError = SemanticMappingUtils.validateSemanticInfoFieldName(semanticFieldPath, semanticFieldConfig);
            if (validateModelIdError != null) {
                errors.add(validateModelIdError);
            }
            if (validateSemanticInfoFieldNameError == null) continue;
            errors.add(validateSemanticInfoFieldNameError);
        }
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(String.join((CharSequence)"; ", errors));
        }
    }

    private void fetchModelAndModifyMapping(@NonNull Map<String, Map<String, Object>> semanticFieldPathToConfigMap, @NonNull Map<String, Object> mappings, @NonNull ActionListener<Void> listener) {
        Objects.requireNonNull(semanticFieldPathToConfigMap, "semanticFieldPathToConfigMap is marked non-null but is null");
        Objects.requireNonNull(mappings, "mappings is marked non-null but is null");
        Objects.requireNonNull(listener, "listener is marked non-null but is null");
        Map<String, List<String>> modelIdToFieldPathMap = SemanticMappingUtils.extractModelIdToFieldPathMap(semanticFieldPathToConfigMap);
        this.mlClientAccessor.getModels(modelIdToFieldPathMap.keySet(), modelIdToConfigMap -> {
            this.modifyMappings((Map<String, MLModel>)modelIdToConfigMap, mappings, modelIdToFieldPathMap, semanticFieldPathToConfigMap);
            listener.onResponse(null);
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private void modifyMappings(@NonNull Map<String, MLModel> modelIdToConfigMap, @NonNull Map<String, Object> mappings, @NonNull Map<String, List<String>> modelIdToFieldPathMap, @NonNull Map<String, Map<String, Object>> semanticFieldPathToConfigMap) {
        Objects.requireNonNull(modelIdToConfigMap, "modelIdToConfigMap is marked non-null but is null");
        Objects.requireNonNull(mappings, "mappings is marked non-null but is null");
        Objects.requireNonNull(modelIdToFieldPathMap, "modelIdToFieldPathMap is marked non-null but is null");
        Objects.requireNonNull(semanticFieldPathToConfigMap, "semanticFieldPathToConfigMap is marked non-null but is null");
        for (String modelId : modelIdToFieldPathMap.keySet()) {
            MLModel mlModel = modelIdToConfigMap.get(modelId);
            List<String> fieldPathList = modelIdToFieldPathMap.get(modelId);
            for (String fieldPath : fieldPathList) {
                try {
                    Map<String, Object> fieldConfig = semanticFieldPathToConfigMap.get(fieldPath);
                    Map<String, Object> semanticInfoConfig = this.createSemanticInfoField(mlModel, modelId, fieldConfig, fieldPath);
                    this.setSemanticInfoField(mappings, fieldPath, fieldConfig.get("semantic_info_field_name"), semanticInfoConfig);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(this.getModifyMappingErrorMessage(fieldPath, e.getMessage()), e);
                }
                catch (Exception e) {
                    throw new RuntimeException(this.getModifyMappingErrorMessage(fieldPath, e.getMessage()), e);
                }
            }
        }
    }

    private String getModifyMappingErrorMessage(@NonNull String fieldPath, String cause) {
        Objects.requireNonNull(fieldPath, "fieldPath is marked non-null but is null");
        return String.format(Locale.ROOT, "Failed to transform the mapping for the semantic field at %s due to %s", fieldPath, cause);
    }

    @VisibleForTesting
    private Map<String, Object> createSemanticInfoField(@NonNull MLModel modelConfig, String modelId, @NonNull Map<String, Object> fieldConfig, String fieldPath) {
        Objects.requireNonNull(modelConfig, "modelConfig is marked non-null but is null");
        Objects.requireNonNull(fieldConfig, "fieldConfig is marked non-null but is null");
        SemanticInfoConfigBuilder builder = new SemanticInfoConfigBuilder(this.xContentRegistry);
        builder.mlModel(modelConfig, modelId);
        builder.chunkingEnabled(SemanticMappingUtils.isChunkingEnabled(fieldConfig, fieldPath));
        builder.semanticFieldSearchAnalyzer(SemanticMappingUtils.getSemanticFieldSearchAnalyzer(fieldConfig, fieldPath));
        builder.denseEmbeddingConfig(SemanticMappingUtils.getDenseEmbeddingConfig(fieldConfig, fieldPath));
        builder.sparseEncodingConfigDefined(fieldConfig.containsKey("sparse_encoding_config"));
        return builder.build();
    }

    private void setSemanticInfoField(@NonNull Map<String, Object> mappings, @NonNull String fullPath, Object userDefinedSemanticInfoFieldName, @NonNull Map<String, Object> semanticInfoConfig) {
        Objects.requireNonNull(mappings, "mappings is marked non-null but is null");
        Objects.requireNonNull(fullPath, "fullPath is marked non-null but is null");
        Objects.requireNonNull(semanticInfoConfig, "semanticInfoConfig is marked non-null but is null");
        Map current = mappings;
        String[] paths = fullPath.split("\\.");
        String semanticInfoFieldName = userDefinedSemanticInfoFieldName == null ? paths[paths.length - 1] + "_semantic_info" : (String)userDefinedSemanticInfoFieldName;
        for (int i = 0; i < paths.length - 1; ++i) {
            String interFieldName = paths[i];
            Map<String, Object> interFieldConfig = (Map<String, Object>)current.get(interFieldName);
            if (interFieldConfig == null) {
                interFieldConfig = this.unflattenMapping(interFieldName, current);
            }
            if (!interFieldConfig.containsKey("properties")) continue;
            current = (Map)interFieldConfig.get("properties");
        }
        current.put((String)semanticInfoFieldName, semanticInfoConfig);
    }

    private Map<String, Object> unflattenMapping(@NonNull String interFieldName, @NonNull Map<String, Object> current) {
        Objects.requireNonNull(interFieldName, "interFieldName is marked non-null but is null");
        Objects.requireNonNull(current, "current is marked non-null but is null");
        String prefix = interFieldName + ".";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        HashMap<String, Object> interFieldConfig = new HashMap<String, Object>();
        interFieldConfig.put("properties", properties);
        Set<String> matchedKeySet = current.keySet().stream().filter(k -> k.startsWith(prefix)).collect(Collectors.toSet());
        for (String key : matchedKeySet) {
            properties.put(key.substring(prefix.length()), current.get(key));
        }
        matchedKeySet.forEach(current::remove);
        current.put(interFieldName, interFieldConfig);
        return interFieldConfig;
    }
}

