/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.settings;

import lombok.Generated;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.neuralsearch.settings.NeuralSearchSettings;
import org.opensearch.neuralsearch.sparse.algorithm.ClusterTrainingExecutor;
import org.opensearch.neuralsearch.sparse.cache.CircuitBreakerManager;
import org.opensearch.neuralsearch.sparse.cache.MemoryUsageManager;
import org.opensearch.neuralsearch.stats.events.EventStatsManager;

public class NeuralSearchSettingsAccessor {
    private volatile boolean isStatsEnabled;
    private volatile boolean isAgenticSearchEnabled;

    public NeuralSearchSettingsAccessor(ClusterService clusterService, Settings settings) {
        this.isStatsEnabled = (Boolean)NeuralSearchSettings.NEURAL_STATS_ENABLED.get(settings);
        this.registerSettingsCallbacks(clusterService, settings);
    }

    private void registerSettingsCallbacks(ClusterService clusterService, Settings settings) {
        clusterService.getClusterSettings().addSettingsUpdateConsumer(NeuralSearchSettings.NEURAL_STATS_ENABLED, value -> {
            if (this.isStatsEnabled && !value.booleanValue()) {
                EventStatsManager.instance().reset();
            }
            this.isStatsEnabled = value;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(NeuralSearchSettings.NEURAL_CIRCUIT_BREAKER_LIMIT, NeuralSearchSettings.NEURAL_CIRCUIT_BREAKER_OVERHEAD, (limit, overhead) -> {
            CircuitBreakerManager.setLimitAndOverhead(limit, overhead);
            MemoryUsageManager.getInstance().setLimitAndOverhead((ByteSizeValue)limit, (double)overhead);
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(NeuralSearchSettings.SPARSE_ALGO_PARAM_INDEX_THREAD_QTY_SETTING, setting -> {
            int maxThreadQty = OpenSearchExecutors.allocatedProcessors((Settings)settings);
            ClusterTrainingExecutor.updateThreadPoolSize(maxThreadQty, setting);
        });
    }

    @Generated
    public boolean isStatsEnabled() {
        return this.isStatsEnabled;
    }

    @Generated
    public boolean isAgenticSearchEnabled() {
        return this.isAgenticSearchEnabled;
    }
}

