/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.List;
import software.amazon.cryptography.materialproviders.ClientSupplier;
import software.amazon.cryptography.materialproviders.IClientSupplier;

public class CreateAwsKmsMrkMultiKeyringInput {
    private final String generator;
    private final List<String> kmsKeyIds;
    private final IClientSupplier clientSupplier;
    private final List<String> grantTokens;

    protected CreateAwsKmsMrkMultiKeyringInput(BuilderImpl builder) {
        this.generator = builder.generator();
        this.kmsKeyIds = builder.kmsKeyIds();
        this.clientSupplier = builder.clientSupplier();
        this.grantTokens = builder.grantTokens();
    }

    public String generator() {
        return this.generator;
    }

    public List<String> kmsKeyIds() {
        return this.kmsKeyIds;
    }

    public IClientSupplier clientSupplier() {
        return this.clientSupplier;
    }

    public List<String> grantTokens() {
        return this.grantTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String generator;
        protected List<String> kmsKeyIds;
        protected IClientSupplier clientSupplier;
        protected List<String> grantTokens;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CreateAwsKmsMrkMultiKeyringInput model) {
            this.generator = model.generator();
            this.kmsKeyIds = model.kmsKeyIds();
            this.clientSupplier = model.clientSupplier();
            this.grantTokens = model.grantTokens();
        }

        @Override
        public Builder generator(String generator) {
            this.generator = generator;
            return this;
        }

        @Override
        public String generator() {
            return this.generator;
        }

        @Override
        public Builder kmsKeyIds(List<String> kmsKeyIds) {
            this.kmsKeyIds = kmsKeyIds;
            return this;
        }

        @Override
        public List<String> kmsKeyIds() {
            return this.kmsKeyIds;
        }

        @Override
        public Builder clientSupplier(IClientSupplier clientSupplier) {
            this.clientSupplier = ClientSupplier.wrap(clientSupplier);
            return this;
        }

        @Override
        public IClientSupplier clientSupplier() {
            return this.clientSupplier;
        }

        @Override
        public Builder grantTokens(List<String> grantTokens) {
            this.grantTokens = grantTokens;
            return this;
        }

        @Override
        public List<String> grantTokens() {
            return this.grantTokens;
        }

        @Override
        public CreateAwsKmsMrkMultiKeyringInput build() {
            return new CreateAwsKmsMrkMultiKeyringInput(this);
        }
    }

    public static interface Builder {
        public Builder generator(String var1);

        public String generator();

        public Builder kmsKeyIds(List<String> var1);

        public List<String> kmsKeyIds();

        public Builder clientSupplier(IClientSupplier var1);

        public IClientSupplier clientSupplier();

        public Builder grantTokens(List<String> var1);

        public List<String> grantTokens();

        public CreateAwsKmsMrkMultiKeyringInput build();
    }
}

