/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wbs;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexOr;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.Direction;
import net.sourceforge.plantuml.utils.LineLocation;
import net.sourceforge.plantuml.warning.Warning;
import net.sourceforge.plantuml.wbs.WBSDiagram;

public class CommandWBSItemOld
extends SingleLineCommand2<WBSDiagram> {
    public CommandWBSItemOld(int mode) {
        super(false, CommandWBSItemOld.getRegexConcat(mode));
    }

    static IRegex getRegexConcat(int mode) {
        if (mode == 0) {
            return RegexConcat.build(CommandWBSItemOld.class.getName() + mode, RegexLeaf.start(), new RegexLeaf(1, "TYPE", "([ \t]*[*+-]+)"), new RegexOr(new RegexConcat(new RegexOptional((IRegex)new RegexLeaf(1, "BACKCOLOR_1", "\\[(#\\w+)\\]")), new RegexOptional((IRegex)new RegexLeaf(1, "CODE_1", "\\(([%pLN_]+)\\)"))), new RegexConcat(new RegexOptional((IRegex)new RegexLeaf(1, "CODE_2", "\\(([%pLN_]+)\\)")), new RegexOptional((IRegex)new RegexLeaf(1, "BACKCOLOR_2", "\\[(#\\w+)\\]")))), new RegexOr(new RegexConcat(new RegexLeaf(1, "SHAPE_1", "(_)?"), new RegexLeaf(1, "DIRECTION_1", "([<>])?")), new RegexConcat(new RegexLeaf(1, "DIRECTION_2", "([<>])?")), new RegexLeaf(1, "SHAPE_2", "(_)?")), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "LABEL", "([^%s].*)"), RegexLeaf.end());
        }
        return RegexConcat.build(CommandWBSItemOld.class.getName() + mode, RegexLeaf.start(), new RegexLeaf(1, "TYPE", "([ \t]*[*+-]+)"), new RegexOptional((IRegex)new RegexLeaf(1, "BACKCOLOR", "\\[(#\\w+)\\]")), new RegexOr(new RegexConcat(new RegexLeaf(1, "SHAPE_1", "(_)?"), new RegexLeaf(1, "DIRECTION_1", "([<>])?")), new RegexConcat(new RegexLeaf(1, "DIRECTION_2", "([<>])?")), new RegexLeaf(1, "SHAPE_2", "(_)?")), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "LABEL", "[%g](.*)[%g]"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "CODE", "([%pLN_]+)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(WBSDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        String type = arg.get("TYPE", 0);
        String label = arg.get("LABEL", 0);
        String code = arg.getLazzy("CODE", 0);
        String stringColor = arg.getLazzy("BACKCOLOR", 0);
        HColor backColor = null;
        if (stringColor != null) {
            backColor = diagram.getSkinParam().getIHtmlColorSet().getColor(stringColor);
        }
        Direction dir = Direction.getWBSDirection(arg);
        diagram.addWarning(new Warning("Please define Direction/Shape before Color/Id."));
        return diagram.addIdea(code, backColor, diagram.getSmartLevel(type), label, dir, IdeaShape.fromDesc(arg.getLazzy("SHAPE", 0)));
    }
}

