
use builtin;
use str;

set edit:completion:arg-completer[rage-mount] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'rage-mount'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'rage-mount'= {
            cand -t 'Indicates the filesystem type (one of "tar", "zip").'
            cand --types 'Indicates the filesystem type (one of "tar", "zip").'
            cand --max-work-factor 'Maximum work factor to allow for passphrase decryption.'
            cand -i 'Use the identity file at IDENTITY. May be repeated.'
            cand --identity 'Use the identity file at IDENTITY. May be repeated.'
            cand -h 'Print this help message and exit.'
            cand --help 'Print this help message and exit.'
            cand -V 'Print version info and exit.'
            cand --version 'Print version info and exit.'
        }
    ]
    $completions[$command]
}
