/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.parser;

import java.util.Set;
import java.util.TreeSet;
import net.sf.jsqlparser.parser.ASTNodeAccess;
import net.sf.jsqlparser.parser.SimpleNode;
import net.sf.jsqlparser.parser.Token;

public class ASTNodeAccessImpl
implements ASTNodeAccess {
    private transient SimpleNode node;

    @Override
    public SimpleNode getASTNode() {
        return this.node;
    }

    @Override
    public void setASTNode(SimpleNode node) {
        this.node = node;
    }

    public StringBuilder appendTo(StringBuilder builder) {
        TreeSet<String> punctuation = new TreeSet<String>(Set.of(".", "[", "]"));
        SimpleNode simpleNode = this.getASTNode();
        if (simpleNode != null) {
            Token token = simpleNode.jjtGetFirstToken();
            Token lastToken = simpleNode.jjtGetLastToken();
            Token prevToken = null;
            while (token.next != null && token.absoluteEnd <= lastToken.absoluteEnd) {
                if (!(punctuation.contains(token.image) || prevToken != null && punctuation.contains(prevToken.image))) {
                    builder.append(" ");
                }
                builder.append(token.image);
                prevToken = token;
                token = token.next;
            }
        }
        return builder;
    }

    public ASTNodeAccess getParent() {
        SimpleNode parent = (SimpleNode)this.node.jjtGetParent();
        while (parent.jjtGetValue() == null) {
            parent = (SimpleNode)parent.jjtGetParent();
        }
        return (ASTNodeAccess)ASTNodeAccess.class.cast(parent.jjtGetValue());
    }

    public <T extends ASTNodeAccess> T getParent(Class<T> clazz) {
        SimpleNode parent = (SimpleNode)this.node.jjtGetParent();
        while (parent.jjtGetValue() == null || !clazz.isInstance(parent.jjtGetValue())) {
            parent = (SimpleNode)parent.jjtGetParent();
        }
        return (T)((ASTNodeAccess)clazz.cast(parent.jjtGetValue()));
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }
}

