﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/forecast/ForecastService_EXPORTS.h>
#include <aws/forecast/model/DatasetSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ForecastService {
namespace Model {
class ListDatasetsResult {
 public:
  AWS_FORECASTSERVICE_API ListDatasetsResult() = default;
  AWS_FORECASTSERVICE_API ListDatasetsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_FORECASTSERVICE_API ListDatasetsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>An array of objects that summarize each dataset's properties.</p>
   */
  inline const Aws::Vector<DatasetSummary>& GetDatasets() const { return m_datasets; }
  template <typename DatasetsT = Aws::Vector<DatasetSummary>>
  void SetDatasets(DatasetsT&& value) {
    m_datasetsHasBeenSet = true;
    m_datasets = std::forward<DatasetsT>(value);
  }
  template <typename DatasetsT = Aws::Vector<DatasetSummary>>
  ListDatasetsResult& WithDatasets(DatasetsT&& value) {
    SetDatasets(std::forward<DatasetsT>(value));
    return *this;
  }
  template <typename DatasetsT = DatasetSummary>
  ListDatasetsResult& AddDatasets(DatasetsT&& value) {
    m_datasetsHasBeenSet = true;
    m_datasets.emplace_back(std::forward<DatasetsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If the response is truncated, Amazon Forecast returns this token. To retrieve
   * the next set of results, use the token in the next request.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListDatasetsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListDatasetsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<DatasetSummary> m_datasets;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_datasetsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ForecastService
}  // namespace Aws
