﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/qconnect/QConnectRequest.h>
#include <aws/qconnect/QConnect_EXPORTS.h>

#include <utility>

namespace Aws {
namespace QConnect {
namespace Model {

/**
 */
class DeleteAIPromptVersionRequest : public QConnectRequest {
 public:
  AWS_QCONNECT_API DeleteAIPromptVersionRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteAIPromptVersion"; }

  AWS_QCONNECT_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The identifier of the Amazon Q in Connect assistant. Can be either the ID or
   * the ARN. URLs cannot contain the ARN.</p>
   */
  inline const Aws::String& GetAssistantId() const { return m_assistantId; }
  inline bool AssistantIdHasBeenSet() const { return m_assistantIdHasBeenSet; }
  template <typename AssistantIdT = Aws::String>
  void SetAssistantId(AssistantIdT&& value) {
    m_assistantIdHasBeenSet = true;
    m_assistantId = std::forward<AssistantIdT>(value);
  }
  template <typename AssistantIdT = Aws::String>
  DeleteAIPromptVersionRequest& WithAssistantId(AssistantIdT&& value) {
    SetAssistantId(std::forward<AssistantIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the Amazon Q in Connect AI prompt.</p>
   */
  inline const Aws::String& GetAiPromptId() const { return m_aiPromptId; }
  inline bool AiPromptIdHasBeenSet() const { return m_aiPromptIdHasBeenSet; }
  template <typename AiPromptIdT = Aws::String>
  void SetAiPromptId(AiPromptIdT&& value) {
    m_aiPromptIdHasBeenSet = true;
    m_aiPromptId = std::forward<AiPromptIdT>(value);
  }
  template <typename AiPromptIdT = Aws::String>
  DeleteAIPromptVersionRequest& WithAiPromptId(AiPromptIdT&& value) {
    SetAiPromptId(std::forward<AiPromptIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version number of the AI Prompt version to be deleted.</p>
   */
  inline long long GetVersionNumber() const { return m_versionNumber; }
  inline bool VersionNumberHasBeenSet() const { return m_versionNumberHasBeenSet; }
  inline void SetVersionNumber(long long value) {
    m_versionNumberHasBeenSet = true;
    m_versionNumber = value;
  }
  inline DeleteAIPromptVersionRequest& WithVersionNumber(long long value) {
    SetVersionNumber(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_assistantId;

  Aws::String m_aiPromptId;

  long long m_versionNumber{0};
  bool m_assistantIdHasBeenSet = false;
  bool m_aiPromptIdHasBeenSet = false;
  bool m_versionNumberHasBeenSet = false;
};

}  // namespace Model
}  // namespace QConnect
}  // namespace Aws
