﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/firehose/Firehose_EXPORTS.h>

namespace Aws {
namespace Firehose {
namespace Model {
enum class HECEndpointType { NOT_SET, Raw, Event };

namespace HECEndpointTypeMapper {
AWS_FIREHOSE_API HECEndpointType GetHECEndpointTypeForName(const Aws::String& name);

AWS_FIREHOSE_API Aws::String GetNameForHECEndpointType(HECEndpointType value);
}  // namespace HECEndpointTypeMapper
}  // namespace Model
}  // namespace Firehose
}  // namespace Aws
