/*
 * Decompiled with CFR 0.152.
 */
package base;

import base.DebugLog;
import base.Util;
import config.AdditionalDataSet;
import config.ExperimentReference;
import config.Round0;
import config.SELEXProcessConfig;
import config.SELEXSequencingConfig;
import config.Sample;
import config.SequencingRunInfo;
import config.Settings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class SELEXConfigReader {
    private SELEXProcessConfig processConfig;
    private HashSet<SeqSampleRound> configSet = new HashSet();
    private HashMap<String, String> seqFileMapping = new HashMap();

    public void clear() {
        this.configSet.clear();
        this.seqFileMapping.clear();
        this.processConfig = null;
    }

    public static void main(String[] stringArray) throws Exception {
        SELEXConfigReader sELEXConfigReader = new SELEXConfigReader();
        String string = "config-Process.xml";
        sELEXConfigReader.readConfig(string, null);
    }

    public static void writeConfig(String string, Object object) throws Exception {
        JAXBContext jAXBContext = JAXBContext.newInstance("config");
        Marshaller marshaller = jAXBContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", true);
        marshaller.marshal(object, new FileOutputStream(string));
    }

    public void readAdditionalDS(List<AdditionalDataSet> list) {
        this.reloadAdditionalSequenceConfig(list);
    }

    public void readConfig(String string, String string2) throws Exception {
        Object object;
        JAXBContext jAXBContext = JAXBContext.newInstance("config");
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        File file = new File(string);
        String string3 = file.getParent();
        if (!Util.isEmpty(string2)) {
            string3 = string2;
        }
        if ((object = unmarshaller.unmarshal(new FileInputStream(string))) instanceof SELEXProcessConfig) {
            this.processConfig = (SELEXProcessConfig)object;
            for (String string4 : this.processConfig.getSequencingConfigPath()) {
                if (!Util.isAbsolutePath(string4)) {
                    string4 = file.getParent() + "/" + string4;
                }
                DebugLog.log("Reading config .. " + string4);
                SELEXSequencingConfig sELEXSequencingConfig = (SELEXSequencingConfig)unmarshaller.unmarshal(new FileInputStream(string4));
                for (SequencingRunInfo sequencingRunInfo : sELEXSequencingConfig.getSequencingRunInfo()) {
                    String string5 = sequencingRunInfo.getDataFile();
                    if (!Util.isAbsolutePath(string5)) {
                        String string6 = string3 + File.separator + string5;
                        sequencingRunInfo.setDataFile(string6);
                        DebugLog.log("Replacing path from [" + string5 + "]to [" + string6 + "].");
                        if (!new File(string6).exists()) {
                            throw new RuntimeException("File [" + string6 + "] doesn't exist.");
                        }
                    }
                    this.addSequencingConfig(sequencingRunInfo);
                }
            }
        } else if (object instanceof SELEXSequencingConfig) {
            SELEXSequencingConfig sELEXSequencingConfig = (SELEXSequencingConfig)object;
            for (SequencingRunInfo sequencingRunInfo : sELEXSequencingConfig.getSequencingRunInfo()) {
                String string7 = sequencingRunInfo.getDataFile();
                if (!Util.isAbsolutePath(string7)) {
                    String string8 = string3 + File.separator + string7;
                    sequencingRunInfo.setDataFile(string8);
                    DebugLog.log("Replacing path from [" + string7 + "]to [" + string8 + "].");
                    if (!new File(string8).exists()) {
                        throw new RuntimeException("File [" + string8 + "] doesn't exist.");
                    }
                }
                this.addSequencingConfig(sequencingRunInfo);
            }
        } else {
            throw new RuntimeException("Unknowd config object:" + object);
        }
    }

    public void reloadAdditionalSequenceConfig(List<AdditionalDataSet> list) {
        for (AdditionalDataSet additionalDataSet : list) {
            String string = additionalDataSet.getConfigurationPath();
            try {
                this.readConfig(string, null);
            }
            catch (Exception exception) {
                DebugLog.log(exception);
            }
        }
    }

    public void addSequencingConfig(SequencingRunInfo sequencingRunInfo) {
        String string = sequencingRunInfo.getName();
        String string2 = this.seqFileMapping.get(string);
        if (!Util.isEmpty(sequencingRunInfo.getDataFile())) {
            try {
                String string3 = new File(sequencingRunInfo.getDataFile()).getCanonicalPath();
                if (string2 != null && !string3.equals(string2 = new File(string2).getCanonicalPath())) {
                    throw new RuntimeException("SeqName[" + string + "] is already mapped to the fastq file[" + string2 + "]");
                }
                this.seqFileMapping.put(string, string3);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        } else {
            if (string2 == null) {
                throw new RuntimeException("SeqName[" + string + "] is not mapped to a fastq file.");
            }
            sequencingRunInfo.setDataFile(string2);
        }
        this.fillInDefaultValues(sequencingRunInfo);
        for (Sample sample : sequencingRunInfo.getSample()) {
            boolean bl;
            this.fillInDefaultValues(sample);
            SeqSampleRound seqSampleRound = new SeqSampleRound();
            seqSampleRound.setSample(sample);
            seqSampleRound.setSeqRunInfo(sequencingRunInfo);
            Round0 round0 = sample.getRound0();
            if (round0 != null) {
                seqSampleRound.round0SeqName = round0.getSequencingName();
                seqSampleRound.round0SampleName = round0.getSampleName();
            }
            if (bl = this.configSet.contains(seqSampleRound)) {
                this.configSet.remove(seqSampleRound);
                DebugLog.log("Duplicate sample found. Overwriting : " + seqSampleRound);
            }
            DebugLog.log("Adding:" + seqSampleRound);
            this.configSet.add(seqSampleRound);
        }
    }

    public ExperimentReference getRound0(ExperimentReference experimentReference) {
        SeqSampleRound seqSampleRound = new SeqSampleRound();
        seqSampleRound.setExperimentReference(experimentReference);
        SeqSampleRound seqSampleRound2 = null;
        for (SeqSampleRound object : this.configSet) {
            if (!object.equals(seqSampleRound)) continue;
            seqSampleRound2 = new SeqSampleRound();
            seqSampleRound2.round = 0;
            seqSampleRound2.sampleName = object.round0SampleName;
            seqSampleRound2.seqName = object.round0SeqName;
        }
        if (seqSampleRound2 != null && seqSampleRound2.seqName != null && seqSampleRound2.sampleName != null) {
            ExperimentReference experimentReference2 = new ExperimentReference();
            experimentReference2.setSampleRound(0);
            experimentReference2.setSequencingName(seqSampleRound2.seqName);
            experimentReference2.setSampleName(seqSampleRound2.sampleName);
            Sample sample = this.getSample(experimentReference2);
            if (sample == null) {
                DebugLog.log("Can't find the Round-0 sample of [" + seqSampleRound + "]");
                return null;
            }
            return experimentReference2;
        }
        DebugLog.log("Round-0 sample of [" + seqSampleRound + "] is not specified.");
        return null;
    }

    private void fillInDefaultValues(SequencingRunInfo sequencingRunInfo) {
        if (sequencingRunInfo.getDescription() == null) {
            sequencingRunInfo.setDescription("");
        }
        if (sequencingRunInfo.getNotes() == null) {
            sequencingRunInfo.setNotes("");
        }
        if (sequencingRunInfo.getResearcherEmail() == null) {
            sequencingRunInfo.setResearcherEmail("");
        }
        if (sequencingRunInfo.getResearcherName() == null) {
            sequencingRunInfo.setResearcherName("");
        }
        if (sequencingRunInfo.getSequencingFacilityEmail() == null) {
            sequencingRunInfo.setSequencingFacilityEmail("");
        }
        if (sequencingRunInfo.getSequencingFacilityName() == null) {
            sequencingRunInfo.setSequencingFacilityName("");
        }
        if (sequencingRunInfo.getSequencingPlatform() == null) {
            sequencingRunInfo.setSequencingPlatform("");
        }
    }

    private void fillInDefaultValues(Sample sample) {
        if (sample.getProtein() == null) {
            sample.setProtein("");
        }
        if (sample.getConcentration() == null) {
            sample.setConcentration("");
        }
        if (sample.getNotes() == null) {
            sample.setNotes("");
        }
    }

    public void exportSamples(String string) {
        SELEXSequencingConfig sELEXSequencingConfig = new SELEXSequencingConfig();
        HashSet<String> hashSet = new HashSet<String>();
        for (SeqSampleRound seqSampleRound : this.configSet) {
            if (hashSet.contains(seqSampleRound.seqName)) continue;
            hashSet.add(seqSampleRound.seqName);
            sELEXSequencingConfig.getSequencingRunInfo().add(seqSampleRound.seqRunInfo);
        }
        try {
            SELEXConfigReader.writeConfig(string, sELEXSequencingConfig);
            DebugLog.log("File output:" + string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public SELEXProcessConfig getProcessConfig() {
        return this.processConfig;
    }

    public Settings getModelSettings() {
        if (this.processConfig == null) {
            return null;
        }
        if (this.processConfig.getProcess() == null) {
            return null;
        }
        if (this.processConfig.getProcess().getModel() == null) {
            return null;
        }
        return this.processConfig.getProcess().getModel().getSettings();
    }

    public SequencingRunInfo getSequencingRunInfo(ExperimentReference experimentReference) {
        SeqSampleRound seqSampleRound = new SeqSampleRound();
        seqSampleRound.setExperimentReference(experimentReference);
        for (SeqSampleRound seqSampleRound2 : this.configSet) {
            if (!seqSampleRound2.equals(seqSampleRound)) continue;
            return seqSampleRound2.seqRunInfo;
        }
        DebugLog.log("Can't find SequencingRunInfo[" + seqSampleRound.seqName + "]");
        return null;
    }

    public String getSequencingRunInfoDataFile(String string) {
        String string2 = this.seqFileMapping.get(string);
        if (string2 == null) {
            DebugLog.log("Can't find SequencingRunInfo[" + string + "]");
        }
        return string2;
    }

    public Sample getSample(ExperimentReference experimentReference) {
        SeqSampleRound seqSampleRound = new SeqSampleRound();
        seqSampleRound.setExperimentReference(experimentReference);
        for (SeqSampleRound seqSampleRound2 : this.configSet) {
            if (!seqSampleRound2.equals(seqSampleRound)) continue;
            return seqSampleRound2.sample;
        }
        DebugLog.log("Can't find Sample[" + seqSampleRound + "]");
        return null;
    }

    public Object[] showSamples() {
        Object object;
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        LinkedList<Integer> linkedList3 = new LinkedList<Integer>();
        LinkedList<String> linkedList4 = new LinkedList<String>();
        LinkedList<String> linkedList5 = new LinkedList<String>();
        LinkedList<String> linkedList6 = new LinkedList<String>();
        LinkedList<String> linkedList7 = new LinkedList<String>();
        LinkedList<String> linkedList8 = new LinkedList<String>();
        for (SeqSampleRound stringArray2 : this.configSet) {
            object = stringArray2.sample;
            linkedList.add(stringArray2.seqName);
            linkedList2.add(((Sample)object).getName());
            linkedList3.add(((Sample)object).getRound());
            linkedList4.add(((Sample)object).getLeftBarcode());
            linkedList5.add(((Sample)object).getRightBarcode());
            linkedList8.add(stringArray2.seqRunInfo.getDataFile());
            linkedList6.add(((Sample)object).getLeftFlank());
            linkedList7.add(((Sample)object).getRightFlank());
        }
        String[] stringArray3 = new String[linkedList3.size()];
        String[] stringArray = new String[linkedList3.size()];
        linkedList.toArray(stringArray3);
        linkedList2.toArray(stringArray);
        object = new int[linkedList3.size()];
        for (int stringArray4 = 0; stringArray4 < linkedList3.size(); ++stringArray4) {
            object[stringArray4] = (Integer)linkedList3.get(stringArray4);
        }
        String[] stringArray2 = new String[linkedList3.size()];
        String[] stringArray4 = new String[linkedList3.size()];
        String[] stringArray5 = new String[linkedList3.size()];
        String[] stringArray6 = new String[linkedList3.size()];
        String[] stringArray7 = new String[linkedList3.size()];
        linkedList4.toArray(stringArray2);
        linkedList5.toArray(stringArray4);
        linkedList8.toArray(stringArray5);
        linkedList6.toArray(stringArray6);
        linkedList7.toArray(stringArray7);
        return new Object[]{stringArray3, stringArray, object, stringArray2, stringArray4, stringArray6, stringArray7, stringArray5};
    }

    private class SeqSampleRound {
        String seqName;
        String sampleName;
        Integer round;
        SequencingRunInfo seqRunInfo;
        Sample sample;
        String round0SeqName;
        String round0SampleName;

        private SeqSampleRound() {
        }

        public String toString() {
            return this.seqName + "|" + this.sampleName + "|" + this.round;
        }

        public void setSeqRunInfo(SequencingRunInfo sequencingRunInfo) {
            this.seqRunInfo = sequencingRunInfo;
            this.seqName = sequencingRunInfo.getName();
        }

        public void setSample(Sample sample) {
            this.sample = sample;
            this.sampleName = sample.getName();
            this.round = sample.getRound();
        }

        public void setExperimentReference(ExperimentReference experimentReference) {
            this.seqName = experimentReference.getSequencingName();
            this.sampleName = experimentReference.getSampleName();
            this.round = experimentReference.getSampleRound();
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + (this.round == null ? 0 : this.round.hashCode());
            n = 31 * n + (this.sampleName == null ? 0 : this.sampleName.hashCode());
            n = 31 * n + (this.seqName == null ? 0 : this.seqName.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            SeqSampleRound seqSampleRound = (SeqSampleRound)object;
            if (!this.getOuterType().equals(seqSampleRound.getOuterType())) {
                return false;
            }
            if (this.round == null ? seqSampleRound.round != null : !this.round.equals(seqSampleRound.round)) {
                return false;
            }
            if (this.sampleName == null ? seqSampleRound.sampleName != null : !this.sampleName.equals(seqSampleRound.sampleName)) {
                return false;
            }
            return !(this.seqName == null ? seqSampleRound.seqName != null : !this.seqName.equals(seqSampleRound.seqName));
        }

        private SELEXConfigReader getOuterType() {
            return SELEXConfigReader.this;
        }
    }
}

