/*
 * Decompiled with CFR 0.152.
 */
package jal.String;

import jal.String.BinaryOperator;
import jal.String.BinaryPredicate;
import jal.String.Generator;
import jal.String.Inspection;
import jal.String.Predicate;
import jal.String.UnaryOperator;
import java.util.Random;

public final class Modification {
    private static Random default_RNG = new Random();

    public static void copy(String[] stringArray, String[] stringArray2, int n, int n2, int n3) {
        if (n2 > n) {
            System.arraycopy(stringArray, n, stringArray2, n3, n2 - n);
        }
    }

    public static void swap_ranges(String[] stringArray, String[] stringArray2, int n, int n2, int n3) {
        while (n < n2) {
            String string = stringArray2[n3];
            stringArray2[n3] = stringArray[n];
            stringArray[n] = string;
            ++n;
            ++n3;
        }
    }

    public static void transform(String[] stringArray, String[] stringArray2, int n, int n2, int n3, UnaryOperator unaryOperator) {
        while (n < n2) {
            stringArray2[n3++] = unaryOperator.apply(stringArray[n++]);
        }
    }

    public static void transform(String[] stringArray, String[] stringArray2, String[] stringArray3, int n, int n2, int n3, int n4, BinaryOperator binaryOperator) {
        while (n < n2) {
            stringArray3[n4++] = binaryOperator.apply(stringArray[n++], stringArray2[n3++]);
        }
    }

    public static void replace(String[] stringArray, int n, int n2, String string, String string2) {
        while (n < n2) {
            if (stringArray[n].equals(string)) {
                stringArray[n] = string2;
            }
            ++n;
        }
    }

    public static void replace_if(String[] stringArray, int n, int n2, Predicate predicate, String string) {
        while (n < n2) {
            if (predicate.apply(stringArray[n])) {
                stringArray[n] = string;
            }
            ++n;
        }
    }

    public static void replace_copy(String[] stringArray, String[] stringArray2, int n, int n2, int n3, String string, String string2) {
        while (n < n2) {
            String string3 = stringArray[n++];
            String string4 = stringArray2[n3++] = string3.equals(string) ? string2 : string3;
        }
    }

    public static void replace_copy_if(String[] stringArray, String[] stringArray2, int n, int n2, int n3, Predicate predicate, String string) {
        while (n < n2) {
            String string2 = stringArray[n++];
            String string3 = stringArray2[n3++] = predicate.apply(string2) ? string : string2;
        }
    }

    public static void fill(String[] stringArray, int n, int n2, String string) {
        while (n < n2) {
            stringArray[n++] = string;
        }
    }

    public static void generate(String[] stringArray, int n, int n2, Generator generator) {
        while (n < n2) {
            stringArray[n++] = generator.apply();
        }
    }

    public static int remove_if(String[] stringArray, int n, int n2, String string) {
        int n3 = n2;
        --n;
        while (true) {
            if (++n < n2 && !stringArray[n].equals(string)) {
                continue;
            }
            while (n < --n2 && stringArray[n2].equals(string)) {
            }
            if (n >= n2) {
                return n;
            }
            stringArray[n] = stringArray[n2];
        }
    }

    public static int remove_if(String[] stringArray, int n, int n2, Predicate predicate) {
        int n3 = n2;
        --n;
        while (true) {
            if (++n < n2 && !predicate.apply(stringArray[n])) {
                continue;
            }
            while (n < --n2 && predicate.apply(stringArray[n2])) {
            }
            if (n >= n2) {
                return n;
            }
            stringArray[n] = stringArray[n2];
        }
    }

    public static int stable_remove(String[] stringArray, int n, int n2, String string) {
        n = Inspection.find(stringArray, n, n2, string);
        int n3 = Inspection.find_not(stringArray, n, n2, string);
        while (n3 < n2) {
            stringArray[n++] = stringArray[n3];
            ++n3;
            n3 = Inspection.find_not(stringArray, n3, n2, string);
        }
        return n;
    }

    public static int stable_remove_if(String[] stringArray, int n, int n2, Predicate predicate) {
        n = Inspection.find_if(stringArray, n, n2, predicate);
        int n3 = Inspection.find_if_not(stringArray, n, n2, predicate);
        while (n3 < n2) {
            stringArray[n++] = stringArray[n3];
            ++n3;
            n3 = Inspection.find_if_not(stringArray, n3, n2, predicate);
        }
        return n;
    }

    public static int remove_copy(String[] stringArray, String[] stringArray2, int n, int n2, int n3, String string) {
        while (n < n2) {
            String string2;
            if ((string2 = stringArray[n++]).equals(string)) continue;
            stringArray2[n3++] = string2;
        }
        return n3;
    }

    public static int remove_copy_if(String[] stringArray, String[] stringArray2, int n, int n2, int n3, Predicate predicate) {
        while (n < n2) {
            String string;
            if (predicate.apply(string = stringArray[n++])) continue;
            stringArray2[n3++] = string;
        }
        return n3;
    }

    public static int unique(String[] stringArray, int n, int n2) {
        n = Inspection.adjacent_find(stringArray, n, n2);
        return Modification.unique_copy(stringArray, stringArray, n, n2, n);
    }

    public static int unique(String[] stringArray, int n, int n2, BinaryPredicate binaryPredicate) {
        n = Inspection.adjacent_find(stringArray, n, n2, binaryPredicate);
        return Modification.unique_copy(stringArray, stringArray, n, n2, n, binaryPredicate);
    }

    public static int unique_copy(String[] stringArray, String[] stringArray2, int n, int n2, int n3) {
        if (n >= n2) {
            return n3;
        }
        stringArray2[n3] = stringArray[n];
        while (++n < n2) {
            if (stringArray2[n3].equals(stringArray[n])) continue;
            stringArray2[++n3] = stringArray[n];
        }
        return n3 + 1;
    }

    public static int unique_copy(String[] stringArray, String[] stringArray2, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n3;
        }
        stringArray2[n3] = stringArray[n];
        while (++n < n2) {
            if (binaryPredicate.apply(stringArray2[n3], stringArray[n])) continue;
            stringArray2[++n3] = stringArray[n];
        }
        return n3 + 1;
    }

    public static void reverse(String[] stringArray, int n, int n2) {
        while (n < --n2) {
            String string = stringArray[n];
            stringArray[n++] = stringArray[n2];
            stringArray[n2] = string;
        }
    }

    public static void reverse_copy(String[] stringArray, int n, int n2, int n3) {
        while (n2 > n) {
            stringArray[n3++] = stringArray[--n2];
        }
    }

    public static void reverse_copy(String[] stringArray, String[] stringArray2, int n, int n2, int n3) {
        while (n2 > n) {
            stringArray2[n3++] = stringArray[--n2];
        }
    }

    public static void rotate(String[] stringArray, int n, int n2, int n3) {
        if (n2 != n && n2 != n3) {
            Modification.reverse(stringArray, n, n2);
            Modification.reverse(stringArray, n2, n3);
            Modification.reverse(stringArray, n, n3);
        }
    }

    public static void rotate_copy(String[] stringArray, String[] stringArray2, int n, int n2, int n3, int n4) {
        Modification.copy(stringArray, stringArray2, n2, n3, n4);
        Modification.copy(stringArray, stringArray2, n, n2, n4 + (n3 - n2));
    }

    public static void random_shuffle(String[] stringArray, int n, int n2, Random random) {
        int n3 = n + 1;
        while (n3 < n2) {
            int n4 = Math.abs(random.nextInt()) % (n3 - n + 1);
            String string = stringArray[n4];
            stringArray[n4] = stringArray[n3];
            stringArray[n3] = string;
            ++n3;
        }
    }

    public static void random_shuffle(String[] stringArray, int n, int n2) {
        Modification.random_shuffle(stringArray, n, n2, default_RNG);
    }

    public static int partition(String[] stringArray, int n, int n2, Predicate predicate) {
        --n;
        while (true) {
            if (++n < n2 && predicate.apply(stringArray[n])) {
                continue;
            }
            while (n < --n2 && !predicate.apply(stringArray[n2])) {
            }
            if (n >= n2) {
                return n;
            }
            String string = stringArray[n];
            stringArray[n] = stringArray[n2];
            stringArray[n2] = string;
        }
    }

    public static int stable_partition(String[] stringArray, int n, int n2, Predicate predicate) {
        if (n + 1 < n2) {
            int n3 = n + (n2 - n) / 2;
            int n4 = Modification.stable_partition(stringArray, n, n3, predicate);
            int n5 = Modification.stable_partition(stringArray, n3, n2, predicate);
            Modification.rotate(stringArray, n4, n3, n5);
            return n4 + (n5 - n3);
        }
        if (n >= n2 || !predicate.apply(stringArray[n])) {
            return n;
        }
        return n2;
    }

    private Modification() {
    }
}

