/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.biojava.bio.search.SeqSimilaritySearchResult;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ObjectUtil;
import org.biojava.utils.contract.Contract;

public class SimpleSeqSimilaritySearchResult
implements SeqSimilaritySearchResult,
Cloneable {
    private SymbolList querySequence;
    private SequenceDB sequenceDB;
    private Map searchParameters;
    private List hits;

    public SimpleSeqSimilaritySearchResult(SymbolList symbolList, SequenceDB sequenceDB, Map map, List list) {
        Contract.pre(symbolList != null, "querySequence was null");
        Contract.pre(sequenceDB != null, "sequenceDB was null");
        Contract.pre(list != null, "hits was null");
        this.querySequence = symbolList;
        this.sequenceDB = sequenceDB;
        this.searchParameters = map;
        this.hits = list;
    }

    public Object clone() {
        return this;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        SimpleSeqSimilaritySearchResult simpleSeqSimilaritySearchResult = (SimpleSeqSimilaritySearchResult)object;
        if (!ObjectUtil.equals(this.querySequence, simpleSeqSimilaritySearchResult.querySequence)) {
            return false;
        }
        if (!ObjectUtil.equals(this.sequenceDB, simpleSeqSimilaritySearchResult.sequenceDB)) {
            return false;
        }
        if (!ObjectUtil.equals(this.searchParameters, simpleSeqSimilaritySearchResult.searchParameters)) {
            return false;
        }
        return ObjectUtil.equals(this.hits, simpleSeqSimilaritySearchResult.hits);
    }

    public List getHits() {
        return Collections.unmodifiableList(this.hits);
    }

    public SymbolList getQuerySequence() {
        return this.querySequence;
    }

    public Map getSearchParameters() {
        return this.searchParameters == null ? null : Collections.unmodifiableMap(this.searchParameters);
    }

    public SequenceDB getSequenceDB() {
        return this.sequenceDB;
    }

    public int hashCode() {
        int n = 0;
        n = ObjectUtil.hashCode(n, this.querySequence);
        n = ObjectUtil.hashCode(n, this.sequenceDB);
        n = ObjectUtil.hashCode(n, this.searchParameters);
        n = ObjectUtil.hashCode(n, this.hits);
        return n;
    }

    public String toString() {
        return "SimpleSeqSimilaritySearchResult of " + this.getQuerySequence() + " against " + this.getSequenceDB();
    }
}

