/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.security;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.derby.shared.common.security.SystemPermission;

public final class DatabasePermission
extends Permission {
    public static final String URL_PROTOCOL_DIRECTORY = "directory:";
    public static final String URL_PATH_INCLUSIVE_STRING = "<<ALL FILES>>";
    public static final char URL_PATH_INCLUSIVE_CHAR = 'I';
    public static final char URL_PATH_SEPARATOR_CHAR = '/';
    public static final char URL_PATH_RELATIVE_CHAR = '.';
    public static final char URL_PATH_WILDCARD_CHAR = '*';
    public static final char URL_PATH_RECURSIVE_CHAR = '-';
    public static final String URL_PATH_SEPARATOR_STRING = String.valueOf('/');
    public static final String URL_PATH_RELATIVE_STRING = String.valueOf('.');
    public static final String URL_PATH_RELATIVE_PREFIX = URL_PATH_RELATIVE_STRING + "/";
    public static final String URL_PATH_WILDCARD_STRING = String.valueOf('*');
    public static final String URL_PATH_WILDCARD_SUFFIX = URL_PATH_SEPARATOR_STRING + "*";
    public static final String URL_PATH_RECURSIVE_STRING = String.valueOf('-');
    public static final String URL_PATH_RECURSIVE_SUFFIX = URL_PATH_SEPARATOR_STRING + "-";
    public static final String CREATE = "create";
    protected static final List<String> LEGAL_ACTIONS = new ArrayList<String>();
    private String actions;
    private transient String path;
    private transient String parentPath;
    private transient char pathType;

    public DatabasePermission(String string, String string2) throws IOException {
        super(string);
        this.initActions(string2);
        this.initLocation(string);
    }

    protected void initActions(String string) {
        if (string == null) {
            throw new NullPointerException("actions can't be null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("actions can't be empty");
        }
        Set set = SystemPermission.parseActions((String)string);
        for (String string2 : set) {
            if (LEGAL_ACTIONS.contains(string2)) continue;
            String string3 = "Illegal action '" + string2 + "'";
            throw new IllegalArgumentException(string3);
        }
        ArrayList<String> arrayList = new ArrayList<String>(LEGAL_ACTIONS);
        arrayList.retainAll(set);
        this.actions = SystemPermission.buildActionsString((Iterable)arrayList);
    }

    protected void initLocation(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("URL can't be null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("URL can't be empty");
        }
        if (!string.startsWith(URL_PROTOCOL_DIRECTORY)) {
            String string2 = "Unsupported protocol in URL '" + string + "'";
            throw new IllegalArgumentException(string2);
        }
        Object object = string.substring(URL_PROTOCOL_DIRECTORY.length());
        if (((String)object).equals(URL_PATH_INCLUSIVE_STRING)) {
            this.pathType = (char)73;
        } else if (((String)object).equals(URL_PATH_RECURSIVE_STRING)) {
            this.pathType = (char)45;
            object = URL_PATH_RELATIVE_PREFIX;
        } else if (((String)object).equals(URL_PATH_WILDCARD_STRING)) {
            this.pathType = (char)42;
            object = URL_PATH_RELATIVE_PREFIX;
        } else if (((String)object).endsWith(URL_PATH_RECURSIVE_SUFFIX)) {
            this.pathType = (char)45;
            object = ((String)object).substring(0, ((String)object).length() - 1);
        } else if (((String)object).endsWith(URL_PATH_WILDCARD_SUFFIX)) {
            this.pathType = (char)42;
            object = ((String)object).substring(0, ((String)object).length() - 1);
        } else {
            this.pathType = (char)47;
        }
        if (this.pathType == 'I') {
            this.path = URL_PATH_INCLUSIVE_STRING;
        } else {
            File file;
            String string3;
            if (((String)object).startsWith(URL_PATH_RELATIVE_PREFIX)) {
                string3 = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty("user.dir");
                    }
                });
                object = string3 + URL_PATH_SEPARATOR_STRING + (String)object;
            }
            string3 = object;
            try {
                file = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                    @Override
                    public File run() throws IOException {
                        return new File(string3).getCanonicalFile();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getCause();
            }
            this.path = file.getPath();
            this.parentPath = this.pathType != '/' ? this.path : file.getParent();
        }
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof DatabasePermission)) {
            return false;
        }
        DatabasePermission databasePermission = (DatabasePermission)permission;
        if (this.pathType == 'I') {
            return true;
        }
        if (databasePermission.pathType == 'I') {
            return false;
        }
        if (this.pathType == '-') {
            return databasePermission.parentPath != null && databasePermission.parentPath.startsWith(this.path);
        }
        if (databasePermission.pathType == '-') {
            return false;
        }
        if (this.pathType == '*') {
            return this.path.equals(databasePermission.parentPath);
        }
        if (databasePermission.pathType == '*') {
            return false;
        }
        return this.path.equals(databasePermission.path);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DatabasePermission)) {
            return false;
        }
        DatabasePermission databasePermission = (DatabasePermission)object;
        return this.pathType == databasePermission.pathType && this.path.equals(databasePermission.path);
    }

    @Override
    public int hashCode() {
        return this.path.hashCode() ^ this.pathType;
    }

    @Override
    public String getActions() {
        return this.actions;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initLocation(this.getName());
        this.initActions(this.getActions());
    }

    static {
        LEGAL_ACTIONS.add(CREATE);
    }
}

