## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)

## ----eval = FALSE-------------------------------------------------------------
# if (!require("BiocManager", quietly = TRUE)) {
#     install.packages("BiocManager")
# }
# 
# BiocManager::install("MSstatsBioNet")

## -----------------------------------------------------------------------------
input = data.table::fread(system.file(
    "extdata/garrido-2024.csv",
    package = "MSstatsBioNet"
))
head(input)

## -----------------------------------------------------------------------------
library(MSstatsBioNet)
annotated_df = annotateProteinInfoFromIndra(input, "Uniprot")
head(annotated_df)

## -----------------------------------------------------------------------------
subnetwork <- getSubnetworkFromIndra(annotated_df, pvalueCutoff = 0.05, statement_types = c("Phosphorylation"), logfc_cutoff = 1, force_include_other = c("HGNC:3236"))
head(subnetwork$nodes)
head(subnetwork$edges)

## -----------------------------------------------------------------------------
previewNetworkInBrowser(subnetwork$nodes, subnetwork$edges, displayLabelType = "hgncName")

## -----------------------------------------------------------------------------
sessionInfo()

