## ----include=FALSE------------------------------------------------------------
library(immReferent)
library(BiocStyle)

# Evaluate networked examples only if the corresponding endpoint is reachable
imgt_ok  <- try(is_imgt_available(),  silent = TRUE)
ogrdb_ok <- try(is_ogrdb_available(), silent = TRUE)
imgt_ok  <- if (inherits(imgt_ok,  "try-error")) FALSE else isTRUE(imgt_ok)
ogrdb_ok <- if (inherits(ogrdb_ok, "try-error")) FALSE else isTRUE(ogrdb_ok)

knitr::opts_chunk$set(
  error   = FALSE,
  message = FALSE,
  warning = FALSE,
  tidy    = FALSE
)

## ----setup, eval=FALSE--------------------------------------------------------
# library(immReferent)

## ----find_cache, eval=FALSE---------------------------------------------------
# # This internal function reveals the current cache path
# immReferent:::.get_cache_dir()

## ----change_cache, eval=FALSE-------------------------------------------------
# # Set a new path for the cache
# options(immReferent.cache = "/path/to/my/project/cache")
# 
# # Verify the new location
# immReferent:::.get_cache_dir()
# 
# # Any calls to getIMGT() will now use this new location
# hla_data <- getIMGT(gene = "HLA",
#                     type = "NUC")

## ----eval=FALSE---------------------------------------------------------------
# getIMGT(species = "human", # Download all human Ig genes
#         gene = "IG")
# getIMGT(species = "human", # Download all human TCR genes
#         gene = "TCR")
# getIMGT(gene = "HLA", # Download HLA data
#         type="NUC")

## ----eval=FALSE---------------------------------------------------------------
# igh_ogrdb <- getOGRDB(species = "human", # Human IGH as FASTA
#                       locus = "IGH",
#                       type = "NUC",
#                       format = "FASTA_GAPPED")
# 
# igk_airr <- getOGRDB(species = "human", # Human IGK via AIRR JSON
#                      locus = "IGK",
#                      type = "NUC",
#                      format = "AIRR")
# 
# igl_prot <- getOGRDB(species = "human", # Human IGL FASTA
#                      locus = "IGL",
#                      type = "PROT",
#                      format = "FASTA_UNGAPPED")

## ----eval=FALSE---------------------------------------------------------------
# options(immReferent.cache = "/path/to/your/transferred/cache")
# 
# #IMGT
# ighv_data <- getIMGT(species = "human",
#                      gene = "IGHV",
#                      type = "NUC")
# 
# # OGRDB
# igh_ogrdb <- loadOGRDB(species = "human",
#                        locus = "IGH",
#                        type = "NUC", f
#                        ormat = "FASTA_GAPPED")

