/*
 * Decompiled with CFR 0.152.
 */
package reder.application.graph;

import java.awt.Font;
import reder.application.RederMainFrame;
import reder.application.graph.NodeBank;

public class LegendBank
extends NodeBank {
    private float xposition;
    private float xmove;
    private float xintersp;
    private float yposition;
    private float ymove;
    private float yintersp;
    private float interspace;
    private String legtype;
    private String position;
    private String labx;
    private String legShape;
    private float labxdist;
    private int membership;
    protected int legid;
    protected int slotNumber;
    private boolean isVertical;
    private float totalW;
    private float totalH;
    private float distBorderX;
    private float distBorderY;
    private float maxH;
    private float maxW;
    private float titleWidth;
    private float titleHeight;
    private float maxLabLength;
    private float maxLabLengthPlus;
    private float w;
    private float h;
    private float size;
    private float bend;
    LegendBank legAccount;

    public LegendBank(String strNodeID, int intNodeID) {
        super(strNodeID, intNodeID);
        this.legid = intNodeID;
        this.legtype = "nodesize";
        this.legShape = "SOLID";
        this.totalW = 20.0f;
        this.totalH = 20.0f;
        this.maxH = 20.0f;
        this.maxW = 20.0f;
        this.maxLabLength = 20.0f;
        this.maxLabLengthPlus = 20.0f;
        this.membership = 0;
        this.isVertical = false;
        this.labxdist = 30.0f;
        this.labx = "labx";
        this.titleWidth = 20.0f;
        this.titleHeight = 20.0f;
        this.xintersp = 0.0f;
        this.yintersp = 0.0f;
        this.interspace = 5.0f;
        this.distBorderX = 10.0f;
        this.distBorderY = 10.0f;
        this.slotNumber = 1;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public void setSlotNumber(int slot) {
        this.slotNumber = slot;
    }

    public void resetId(int id) {
        this.legid = id;
    }

    public void setLegShape(String lt) {
        this.legShape = lt;
    }

    public String getLegShape() {
        return this.legShape;
    }

    public void setDistBorder(float x, float y) {
        this.distBorderX = x;
        this.distBorderY = y;
    }

    public void setLegSize(float size, float h, float w) {
        this.size = size;
        this.h = h;
        this.w = w;
    }

    public void setLegSize(float size) {
        this.size = size;
        this.h = size;
        this.w = size;
    }

    public void setLegBend(float bend) {
        this.bend = bend;
    }

    public float getLegH() {
        return this.h;
    }

    public float getLegW() {
        return this.w;
    }

    public float getLegSize() {
        return this.size;
    }

    public float getLegBend() {
        return this.bend;
    }

    public void setTitleWidth(float titlesz) {
        this.titleWidth = titlesz;
    }

    public float getTitleWidth() {
        return this.titleWidth;
    }

    public void setTitleHeight(float titlesz) {
        this.titleHeight = titlesz;
    }

    public float getTitleHeight() {
        return this.titleHeight;
    }

    public Font getTitleFont() {
        Font ft = this.getFont();
        ft = new Font(ft.getFontName(), 1, ft.getSize() + 2);
        return ft;
    }

    public void setMaxLabLength(Float lt) {
        this.maxLabLength = lt.floatValue();
    }

    public Float getMaxLabLength() {
        return Float.valueOf(this.maxLabLength);
    }

    public void setMaxLabLengthPlus(Float lt) {
        this.maxLabLengthPlus = lt.floatValue();
    }

    public Float getMaxLabLengthPlus() {
        return Float.valueOf(this.maxLabLengthPlus);
    }

    public void setLabx(String tl) {
        this.labx = tl;
    }

    public String getLabx() {
        return this.labx;
    }

    public void setLabxDist(float xd) {
        this.labxdist = xd;
    }

    public float getLabxDist() {
        return this.labxdist;
    }

    public void setInterSpace(float sp) {
        this.interspace = sp;
    }

    public float getInterSpace() {
        return this.interspace;
    }

    public float getDistBorderX() {
        return this.distBorderX;
    }

    public float getDistBorderY() {
        return this.distBorderY;
    }

    public void setPanelPosition(String str) {
        this.position = str;
    }

    public String getPanelPosition() {
        return this.position;
    }

    public void realocatePanelPosition(String str) {
        switch (str) {
            case "topLeft": {
                this.position = "topLeft";
                this.topLeft();
                break;
            }
            case "topRight": {
                this.position = "topRight";
                this.topRight();
                break;
            }
            case "bottomLeft": {
                this.position = "bottomLeft";
                this.bottomLeft();
                break;
            }
            case "bottomRight": {
                this.position = "bottomRight";
                this.bottomRight();
                break;
            }
        }
        if (!this.legtype.equals("nodecolor") && !this.legtype.equals("edgecolor")) {
            if (this.isVertical) {
                this.yintersp = this.interspace;
                this.xintersp = 0.0f;
            } else {
                this.yintersp = 0.0f;
                this.xintersp = this.interspace;
            }
        }
        this.setTextPos();
    }

    public String getPanelSideRL() {
        String side = this.position.equals("topLeft") || this.position.equals("bottomLeft") ? "left" : "right";
        return side;
    }

    public String getPanelSideTB() {
        String side = this.position.equals("topLeft") || this.position.equals("topRight") ? "top" : "bottom";
        return side;
    }

    public boolean isEdgeType() {
        return this.legtype.equals("edgewidth") || this.legtype.equals("edgeshape");
    }

    public boolean isSizeWidthType() {
        return this.legtype.equals("nodesize") || this.legtype.equals("edgewidth");
    }

    public float getLegZoom() {
        float zoom = 1.0f;
        if (this.legtype.equals("nodesize") || this.legtype.equals("edgewidth")) {
            zoom = (float)RederMainFrame.getZoom();
        }
        return zoom;
    }

    public void realocateMembers() {
        float relativey;
        float relativex;
        this.realocatePanelPosition(this.position);
        float zoom = this.getLegZoom();
        this.legAccount = RederMainFrame.LegendList.get(this.legid);
        float watual = this.legAccount.getLegW() * zoom;
        float hatual = this.legAccount.getLegH() * zoom;
        float xanterior = 0.0f;
        float yanterior = 0.0f;
        if (this.membership == 0) {
            relativex = watual / 2.0f;
        } else {
            float wanterior = RederMainFrame.LegendList.get(this.legid - 1).getLegW() * zoom;
            xanterior = this.xmove * RederMainFrame.LegendList.get(this.legid - 1).getX() - this.xmove * this.xposition;
            relativex = this.xmove * wanterior / 2.0f + watual / 2.0f;
        }
        if (this.membership == 0) {
            relativey = hatual / 2.0f;
        } else {
            float hanterior = RederMainFrame.LegendList.get(this.legid - 1).getLegH() * zoom;
            yanterior = this.ymove * RederMainFrame.LegendList.get(this.legid - 1).getY() - this.ymove * this.yposition;
            relativey = this.ymove * hanterior / 2.0f + hatual / 2.0f;
        }
        this.legAccount.setX(this.xposition + (relativex += this.xintersp * zoom) + xanterior);
        this.legAccount.setY(this.yposition + (relativey += this.yintersp * zoom) + yanterior);
    }

    public float getGlobalHight() {
        float zoom = this.getLegZoom();
        float gh = this.yposition + this.totalH * zoom + this.yintersp * zoom;
        return gh;
    }

    public float getTitleX() {
        float xt;
        float zn = this.getLegZoom();
        if (this.isVertical) {
            if (this.getPanelSideRL().equals("left")) {
                xt = this.getX() + (this.maxW / 2.0f * zn + this.labxdist);
            } else {
                float sz1 = (this.w / 2.0f + this.totalW / 2.0f) * zn;
                float sz2 = (this.maxW / 2.0f + this.totalW / 2.0f) * zn;
                xt = this.xposition + sz1 - sz2 - this.labxdist;
            }
        } else {
            float d;
            xt = this.xposition + this.xintersp / 2.0f * zn + this.totalW / 2.0f * zn;
            if (this.getPanelSideRL().equals("right") && xt > (d = (float)(RederMainFrame.getSmallViewArea().getWidth() - (double)(this.titleWidth / 2.0f)))) {
                xt = d;
            }
        }
        return xt;
    }

    public float getTitleY() {
        float zn = this.getLegZoom();
        float yt = this.yposition + this.yintersp / 2.0f * zn;
        if (this.isVertical) {
            if (this.getPanelSideTB().equals("top")) {
                float d = this.totalH * zn / 2.0f;
                if (d < this.titleWidth / 2.0f) {
                    d = this.titleWidth / 2.0f;
                }
                yt += d;
            } else {
                float d = this.totalH / 2.0f * zn + this.titleWidth / 2.0f;
                if (d > this.totalH * zn) {
                    d = this.totalH * zn;
                }
                yt += d;
            }
        } else {
            yt -= this.labxdist;
        }
        return yt;
    }

    private void topLeft() {
        this.setLeft();
        this.yposition = this.distBorderY;
    }

    private void bottomLeft() {
        this.setLeft();
        float gh = this.getGlobalHight();
        if (this.isVertical) {
            float offset = (float)RederMainFrame.drawpanel.getHeight() - gh;
            this.yposition += offset;
        } else {
            float offset = (float)RederMainFrame.drawpanel.getHeight() - gh;
            this.yposition += offset;
        }
        this.yposition -= this.distBorderY;
    }

    private void setLeft() {
        float zn = this.getLegZoom();
        float sz = 0.0f;
        if (this.isVertical) {
            sz = this.totalW / 2.0f - RederMainFrame.LegendList.get(this.legid).getLegW() / 2.0f;
        }
        this.xposition = sz * zn + this.distBorderX;
    }

    private void topRight() {
        this.setRight();
        this.yposition = this.distBorderY;
    }

    private void bottomRight() {
        this.setRight();
        float gh = this.getGlobalHight();
        if (this.isVertical) {
            float offset = (float)RederMainFrame.drawpanel.getHeight() - gh;
            this.yposition += offset;
        } else {
            float offset = (float)RederMainFrame.drawpanel.getHeight() - gh;
            this.yposition += offset;
        }
        this.yposition -= this.distBorderY;
    }

    private void setRight() {
        float zn = this.getLegZoom();
        float sz = this.totalW;
        if (this.isVertical) {
            sz = this.w / 2.0f + this.totalW / 2.0f;
        }
        this.xposition = (float)RederMainFrame.drawpanel.getWidth() - sz * zn - this.distBorderX;
    }

    private void setTextPos() {
        float zn = this.getLegZoom();
        this.legAccount = RederMainFrame.LegendList.get(this.legid);
        if (this.isVertical) {
            if (this.getPanelSideRL().equals("left")) {
                this.legAccount.setFontOffsetX(this.w / 2.0f * zn);
            } else {
                this.legAccount.setFontOffsetX(-(1.0f + this.w / 2.0f) * zn);
            }
            this.legAccount.setFontOffsetY(0.0f);
        } else {
            this.legAccount.setFontOffsetY(0.0f);
            this.legAccount.setFontOffsetX(-this.h / 2.0f * zn);
        }
    }

    public void setLegType(String str) {
        this.legtype = str;
    }

    public String getLegType() {
        return this.legtype;
    }

    public void setDim(float tlH, float tlW, float mxH, float mxW) {
        this.totalH = tlH;
        this.totalW = tlW;
        this.maxH = mxH;
        this.maxW = mxW;
    }

    public float getTotalH() {
        return this.totalH;
    }

    public float getTotalLabLengthPlus() {
        float wp = this.isVertical ? this.totalW + this.maxLabLengthPlus + this.titleHeight : this.totalH + this.maxLabLengthPlus + this.titleHeight;
        return wp;
    }

    public void setVertical(boolean b) {
        this.isVertical = b;
        if (this.isVertical) {
            this.xmove = 0.0f;
            this.ymove = 1.0f;
        } else {
            this.xmove = 1.0f;
            this.ymove = 0.0f;
        }
    }

    public boolean isVertical() {
        return this.isVertical;
    }

    public void setMembership(int nm) {
        this.membership = nm;
    }

    public int getMembership() {
        return this.membership;
    }
}

