/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.smp.ca;

import edu.rit.image.GrayImageRow;
import edu.rit.image.PJGGrayImage;
import edu.rit.image.PJGImage;
import edu.rit.numeric.BigRational;
import edu.rit.pj.BarrierAction;
import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.util.Range;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class CCASmp {
    static final BigRational ZERO = new BigRational("0");
    static final BigRational ONE = new BigRational("1");
    static final BigRational ONE_THIRD = new BigRational("1/3");
    static int C;
    static int S;
    static BigRational A;
    static BigRational B;
    static File imagefile;
    static BigRational[] currentCell;
    static BigRational[] nextCell;
    static byte[][] pixelmatrix;
    static PJGGrayImage image;
    static PJGImage.Writer writer;
    static byte[] pixelrow;
    static GrayImageRow imagerow;

    private CCASmp() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        if (stringArray.length != 5) {
            CCASmp.usage();
        }
        boolean bl = false;
        C = Integer.parseInt(stringArray[0]);
        S = Integer.parseInt(stringArray[1]);
        A = new BigRational(stringArray[2]).mul(ONE_THIRD);
        B = new BigRational(stringArray[3]);
        imagefile = new File(stringArray[4]);
        currentCell = new BigRational[C];
        nextCell = new BigRational[C];
        for (int i = 0; i < C; ++i) {
            CCASmp.currentCell[i] = new BigRational();
            CCASmp.nextCell[i] = new BigRational();
        }
        currentCell[C / 2].assign(ONE);
        pixelmatrix = new byte[S + 1][];
        image = new PJGGrayImage(S + 1, C, pixelmatrix);
        writer = image.prepareToWrite(new BufferedOutputStream(new FileOutputStream(imagefile)));
        pixelrow = new byte[C];
        imagerow = new GrayImageRow(pixelrow);
        imagerow.setInterpretation(PJGGrayImage.ZERO_IS_WHITE);
        new ParallelTeam().execute(new ParallelRegion(){

            public void run() throws Exception {
                int n = 0;
                while (n < S) {
                    final int n2 = n++;
                    this.execute(0, C - 1, new IntegerForLoop(){

                        public IntegerSchedule schedule() {
                            return IntegerSchedule.guided();
                        }

                        public void run(int n, int n2) {
                            for (int i = n; i <= n2; ++i) {
                                nextCell[i].assign(currentCell[i]).add(currentCell[(i - 1 + C) % C]).add(currentCell[(i + 1) % C]).mul(A).add(B).normalize().fracPart();
                            }
                        }
                    }, new BarrierAction(){

                        public void run() throws Exception {
                            CCASmp.writeCurrentCell(n2);
                            BigRational[] bigRationalArray = currentCell;
                            currentCell = nextCell;
                            nextCell = bigRationalArray;
                        }
                    });
                }
            }
        });
        CCASmp.writeCurrentCell(S);
        writer.close();
        long l2 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec total");
    }

    private static void writeCurrentCell(int n) throws IOException {
        for (int i = 0; i < C; ++i) {
            imagerow.setPixel(i, currentCell[i].floatValue());
        }
        CCASmp.pixelmatrix[n] = pixelrow;
        writer.writeRowSlice(new Range(n, n));
    }

    private static void usage() {
        System.err.println("Usage: java [-Dpj.nt=<K>] edu.rit.smp.ca.CCASmp <C> <S> <A> <B> <imagefile>");
        System.err.println("<K> = Number of parallel threads");
        System.err.println("<C> = Number of cells (>= 1)");
        System.err.println("<S> = Number of time steps (>= 1)");
        System.err.println("<A> = Multiplicand in update formula (rational number)");
        System.err.println("<B> = Addend in update formula (rational number)");
        System.err.println("<imagefile> = Output PJG image file name");
        System.exit(1);
    }
}

