/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.swing;

import edu.rit.swing.Displayable;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.SimpleDoc;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;

public class DisplayableIO {
    private DisplayableIO() {
    }

    public static void writeBilevelPNGFile(Displayable displayable, File file) throws IOException {
        DisplayableIO.writePNGFile(displayable, file, 1.0, 12, false);
    }

    public static void writeBilevelPNGFile(Displayable displayable, File file, double d) throws IOException {
        DisplayableIO.writePNGFile(displayable, file, d, 12, false);
    }

    public static void writeGrayscalePNGFile(Displayable displayable, File file) throws IOException {
        DisplayableIO.writePNGFile(displayable, file, 1.0, 10, true);
    }

    public static void writeGrayscalePNGFile(Displayable displayable, File file, double d) throws IOException {
        DisplayableIO.writePNGFile(displayable, file, d, 10, true);
    }

    public static void writeColorPNGFile(Displayable displayable, File file) throws IOException {
        DisplayableIO.writePNGFile(displayable, file, 1.0, 1, true);
    }

    public static void writeColorPNGFile(Displayable displayable, File file, double d) throws IOException {
        DisplayableIO.writePNGFile(displayable, file, d, 1, true);
    }

    private static void writePNGFile(Displayable displayable, File file, double d, int n, boolean bl) throws IOException {
        Rectangle2D rectangle2D = displayable.getBoundingBox();
        int n2 = (int)(rectangle2D.getWidth() * d + 0.5);
        int n3 = (int)(rectangle2D.getHeight() * d + 0.5);
        BufferedImage bufferedImage = new BufferedImage(n2, n3, n);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (bl) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        graphics2D.setPaint(displayable.getBackgroundPaint());
        graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, n2, n3));
        graphics2D.scale(d, d);
        graphics2D.translate(-rectangle2D.getX() * d, -rectangle2D.getY() * d);
        displayable.draw(graphics2D);
        ImageIO.write((RenderedImage)bufferedImage, "png", file);
    }

    public static void writePostScriptFile(Displayable displayable, File file) throws IOException {
        DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        StreamPrintServiceFactory[] streamPrintServiceFactoryArray = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(sERVICE_FORMATTED, "application/postscript");
        if (streamPrintServiceFactoryArray.length == 0) {
            throw new IOException("Cannot find PostScript generator");
        }
        final Displayable displayable2 = displayable;
        final Rectangle2D rectangle2D = displayable.getBoundingBox();
        final double d = rectangle2D.getWidth();
        final double d2 = rectangle2D.getHeight();
        Printable printable = new Printable(){

            public int print(Graphics graphics, PageFormat pageFormat, int n) {
                if (n != 0) {
                    return 1;
                }
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                double d4 = pageFormat.getImageableWidth() / d;
                double d22 = pageFormat.getImageableHeight() / d2;
                double d3 = Math.min(1.0, Math.min(d4, d22));
                graphics2D.scale(d3, d3);
                graphics2D.translate(-rectangle2D.getX() * d3, -rectangle2D.getY() * d3);
                displayable2.draw(graphics2D);
                return 0;
            }
        };
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        StreamPrintService streamPrintService = streamPrintServiceFactoryArray[0].getPrintService(fileOutputStream);
        SimpleDoc simpleDoc = new SimpleDoc(printable, sERVICE_FORMATTED, null);
        try {
            streamPrintService.createPrintJob().print(simpleDoc, null);
        }
        catch (PrintException printException) {
            IOException iOException = new IOException("Cannot generate PostScript");
            iOException.initCause(printException);
            throw iOException;
        }
    }
}

