/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.ig.metatarget.datastructures;

import fr.cea.ig.metatarget.MetaBin;
import fr.cea.ig.metatarget.datastructures.ClusterVectorAB;
import fr.cea.ig.metatarget.datastructures.Dictionary;
import fr.cea.ig.metatarget.datastructures.FastaManager;
import fr.cea.ig.metatarget.datastructures.Sequence;
import fr.cea.ig.metatarget.datastructures.VectorUtils;
import fr.cea.ig.metatarget.utils.Coder;
import fr.cea.ig.metatarget.utils.Utils;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

public class SequenceProcessor
implements Runnable {
    private static AtomicInteger sequenceCount = new AtomicInteger(0);
    private static AtomicInteger taskCount = new AtomicInteger(0);
    private final int id = taskCount.getAndIncrement();
    private MetaBin caller;
    private Dictionary dictionary = null;
    private FastaManager frm = null;
    private MODE mode = null;
    private int k;
    private CountDownLatch startSignal = null;
    private CountDownLatch doneSignal = null;
    private Object[] parametersExtra = null;
    private ClusterVectorAB[] ABClusterVectors = null;

    public SequenceProcessor(MetaBin caller, Dictionary dictionary, FastaManager frm, MODE mode, int k, CountDownLatch startSignal, CountDownLatch doneSignal, Object[] parametersExtra) {
        this.caller = caller;
        this.dictionary = dictionary;
        this.frm = frm;
        this.mode = mode;
        this.k = k;
        this.startSignal = startSignal;
        this.doneSignal = doneSignal;
        this.parametersExtra = parametersExtra;
    }

    public static void resetCounters() {
        sequenceCount = new AtomicInteger(0);
        taskCount = new AtomicInteger(0);
    }

    public static AtomicInteger getSequenceCount() {
        return sequenceCount;
    }

    public MODE getMode() {
        return this.mode;
    }

    public void setABClusterVectors(ClusterVectorAB[] ABClusterVectors) {
        this.ABClusterVectors = ABClusterVectors;
    }

    public void setStartSignal(CountDownLatch startSignal) {
        this.startSignal = startSignal;
    }

    public void setDoneSignal(CountDownLatch doneSignal) {
        this.doneSignal = doneSignal;
    }

    public void setMode(MODE mode) {
        this.mode = mode;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void run() {
        try {
            this.startSignal.await();
            boolean done = false;
            System.out.println(Utils.time() + " SequenceProcessor: " + this.id + "\t" + this.mode.toString() + " START");
            block9: while (!done) {
                Sequence sequence = this.frm.getNextSequence();
                if (sequence == null) {
                    if (this.frm.hasMore()) continue;
                    System.out.println(Utils.time() + " SequenceProcessor: " + this.id + "\t" + this.mode.toString() + " EXIT");
                    done = true;
                    break;
                }
                switch (this.mode) {
                    case AB_KMERCOUNT: {
                        this.processSequence_AB_KMERCOUNT(sequence);
                        continue block9;
                    }
                    case AB_BINNING: {
                        this.processSequence_AB_BINNING(sequence);
                        continue block9;
                    }
                    case CB_SEQUENCEVECTORBUILD: {
                        this.processSequence_CB_SEQUENCEVECTORBUILD(sequence);
                        continue block9;
                    }
                    case CB_BINNING: {
                        this.processSequence_CB_BINNING(sequence);
                        continue block9;
                    }
                    case KMERCOUNT_SEQUENCEVECTORBUILD: {
                        System.out.println("UNSUPPORTED");
                        continue block9;
                    }
                }
                System.err.println(Utils.time() + " Mode+\"" + this.mode.toString() + "\" not known.");
            }
            this.doneSignal.countDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processSequence_AB_KMERCOUNT(Sequence sequence) {
        try {
            sequenceCount.incrementAndGet();
            if (sequenceCount.get() % 100000 == 0) {
                System.out.println(Utils.time() + " SequenceProcessor: " + this.id + "\t" + this.mode.toString() + " " + sequenceCount.get());
            }
            for (int i = 0; i <= sequence.getLength() - this.k; ++i) {
                this.dictionary.insert(Coder.encodeToLong(sequence, i, i + this.k, false));
                this.dictionary.insert(Coder.encodeToLong(sequence, i, i + this.k, true));
            }
            sequence.clearFull();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processSequence_AB_BINNING(Sequence sequence) {
        try {
            sequenceCount.incrementAndGet();
            if (sequenceCount.get() % 100000 == 0) {
                System.out.println(Utils.time() + " SequenceProcessor: " + this.id + "\t" + this.mode.toString() + " " + sequenceCount.get());
            }
            int i = 0;
            while (i + this.k <= sequence.getLength()) {
                sequence.insertKmerCount(Coder.encodeToLong(sequence, i, i + this.k, false), 1);
                sequence.insertKmerCount(Coder.encodeToLong(sequence, i, i + this.k, true), 1);
                ++i;
            }
            double maxSim = 0.0;
            int abundanceCluster = -1;
            double[] distances = new double[this.ABClusterVectors.length];
            for (int c = 0; c < this.ABClusterVectors.length; ++c) {
                double similarity = VectorUtils.cosineSequence2Cluster(sequence, this.ABClusterVectors[c]);
                if (similarity > maxSim) {
                    maxSim = similarity;
                    abundanceCluster = c + 1;
                }
                distances[c] = similarity;
            }
            sequence.setAssignedCluster(abundanceCluster);
            sequence.setDistancesToClusters(distances);
            if (this.parametersExtra != null && ((Boolean)this.parametersExtra[0]).booleanValue()) {
                this.caller.saveSeqToCluster(sequence, true);
            } else {
                this.caller.saveSeqToCluster(sequence, false);
            }
            sequence.clearFull();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processSequence_CB_SEQUENCEVECTORBUILD(Sequence sequence) {
        try {
            sequenceCount.incrementAndGet();
            if (sequenceCount.get() % 100000 == 0) {
                System.out.println(Utils.time() + " SequenceProcessor: " + this.id + "\t" + this.mode.toString() + " " + sequenceCount.get());
            }
            int i = 0;
            while (i + this.k <= sequence.getLength()) {
                sequence.insertKmerCount(Coder.encodeToLong(sequence, i, i + this.k, false), 1);
                sequence.insertKmerCount(Coder.encodeToLong(sequence, i, i + this.k, true), 1);
                ++i;
            }
            sequence.clearHeadSeq();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processSequence_CB_BINNING(Sequence sequence) {
        try {
            sequenceCount.incrementAndGet();
            if (sequenceCount.get() % 100000 == 0) {
                System.out.println(Utils.time() + " SequenceProcessor: " + this.id + "\t" + this.mode.toString() + " " + sequenceCount.get());
            }
            if (this.parametersExtra != null && ((Boolean)this.parametersExtra[0]).booleanValue()) {
                this.caller.saveSeqToCluster(sequence, true);
            } else {
                this.caller.saveSeqToCluster(sequence, false);
            }
            sequence.clearFull();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum MODE {
        AB_KMERCOUNT,
        AB_BINNING,
        CB_SEQUENCEVECTORBUILD,
        CB_BINNING,
        KMERCOUNT_SEQUENCEVECTORBUILD;

    }
}

