/*
 * Decompiled with CFR 0.152.
 */
package eponine.model;

import eponine.model.BasisFunctionWithHistory;
import eponine.model.BundleConstraint;
import eponine.model.ConstraintBasisFunction;
import eponine.model.ModelTools;
import eponine.model.PositionedConstraint;
import eponine.model.WeightMatrixConstraint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.Annotation;
import org.biojava.bio.symbol.FundamentalAtomicSymbol;
import stats.glm.BasisFunction;
import stats.glm.BasisSource;
import stats.glm.SLMTrainingContext;

public class ReversibilityBasisSource
extends FundamentalAtomicSymbol
implements BasisSource {
    private double width = 0.05;
    private String name = "reversibility";

    public ReversibilityBasisSource() {
        super("reversibility", ' ', Annotation.EMPTY_ANNOTATION);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    public BasisFunction next(SLMTrainingContext sLMTrainingContext) {
        Object object;
        Object object2;
        List list = sLMTrainingContext.getBasisList();
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object2 = (BasisFunction)iterator.next();
            object = ModelTools.removeHistory((BasisFunction)object2);
            if (!(object instanceof ConstraintBasisFunction)) continue;
            PositionedConstraint positionedConstraint = (PositionedConstraint)((ConstraintBasisFunction)object).getConstraint();
            int n2 = 1;
            if (positionedConstraint.getConstraint() instanceof BundleConstraint) {
                n2 = ((BundleConstraint)positionedConstraint.getConstraint()).getConstraints().size();
            }
            hashMap.put(object2, new Integer(n2));
            n += n2;
        }
        n = (int)Math.ceil((double)n * Math.random());
        object2 = hashMap.entrySet().iterator();
        while (object2.hasNext()) {
            object = (Map.Entry)object2.next();
            int n3 = (Integer)object.getValue();
            if ((n -= n3) > 0) continue;
            BasisFunction basisFunction = (BasisFunction)object.getKey();
            PositionedConstraint positionedConstraint = (PositionedConstraint)ModelTools.getConstraint(basisFunction);
            if (n3 == 1) {
                WeightMatrixConstraint weightMatrixConstraint = (WeightMatrixConstraint)positionedConstraint.getConstraint();
                weightMatrixConstraint = this.sampleWeightMatrixConstraint(weightMatrixConstraint);
                return new BasisFunctionWithHistory(new ConstraintBasisFunction(new PositionedConstraint(weightMatrixConstraint, positionedConstraint.getPosition(), positionedConstraint.getDistribution(), positionedConstraint.isMaximum())), Collections.singleton(basisFunction), this, sLMTrainingContext.getCurrentCycle());
            }
            ArrayList<PositionedConstraint> arrayList = new ArrayList<PositionedConstraint>(((BundleConstraint)positionedConstraint.getConstraint()).getConstraints());
            PositionedConstraint positionedConstraint2 = (PositionedConstraint)arrayList.get(-n);
            WeightMatrixConstraint weightMatrixConstraint = (WeightMatrixConstraint)positionedConstraint2.getConstraint();
            weightMatrixConstraint = this.sampleWeightMatrixConstraint(weightMatrixConstraint);
            arrayList.set(-n, new PositionedConstraint(weightMatrixConstraint, positionedConstraint2.getPosition(), positionedConstraint2.getDistribution(), positionedConstraint2.isMaximum()));
            return new BasisFunctionWithHistory(new ConstraintBasisFunction(new PositionedConstraint(new BundleConstraint(arrayList), positionedConstraint.getPosition(), positionedConstraint.getDistribution(), positionedConstraint.isMaximum())), Collections.singleton(basisFunction), this, sLMTrainingContext.getCurrentCycle());
        }
        System.out.println("totalProb exceeded");
        return null;
    }

    private WeightMatrixConstraint sampleWeightMatrixConstraint(WeightMatrixConstraint weightMatrixConstraint) {
        double d = weightMatrixConstraint.getReversibility();
        double d2 = d + this.width * ModelTools.gauss();
        d2 = Math.min(1.0, Math.max(0.0, d2));
        return new WeightMatrixConstraint(weightMatrixConstraint.getWeightMatrix(), d2);
    }

    public boolean hasNext(SLMTrainingContext sLMTrainingContext) {
        return sLMTrainingContext.getCurrentCycle() > 0 && sLMTrainingContext.getBasisList().size() >= 3;
    }
}

