/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import org.biojava.bio.program.sax.BlastLikeSAXParser;
import org.biojava.bio.program.xml.SimpleXMLEmitter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class BlastLikeToXMLConverter {
    private String oInput;
    private XMLReader oParser;
    private boolean tStrict = true;

    public BlastLikeToXMLConverter(String string) {
        this.oInput = string;
    }

    public void convert() throws IOException, SAXException {
        this.oParser = new BlastLikeSAXParser();
        if (this.tStrict) {
            ((BlastLikeSAXParser)this.oParser).setModeStrict();
        } else {
            ((BlastLikeSAXParser)this.oParser).setModeLazy();
        }
        try {
            this.oParser.setFeature("http://xml.org/features/namespaces", true);
            this.oParser.setFeature("http://xml.org/features/namespace-prefixes", true);
        }
        catch (Exception exception) {
            System.out.println("WARNING: ignoring attempt to set illegal combination of parser features");
        }
        SimpleXMLEmitter simpleXMLEmitter = new SimpleXMLEmitter(true);
        this.oParser.setContentHandler(simpleXMLEmitter);
        Object var4_2 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(this.oInput);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            this.oParser.parse(new InputSource(bufferedReader));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException.getMessage());
            System.out.println("Couldn't open file");
            System.exit(0);
        }
        System.out.println();
    }

    public void setModeLazy() {
        this.tStrict = false;
    }

    public void setModeStrict() {
        this.tStrict = true;
    }
}

