## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)

options(
  tibble.print_min = 4L, 
  tibble.print_max = 4L, 
  rmarkdown.html_vignette.check_title = FALSE
)


## ----setup, message = FALSE---------------------------------------------------
library(tidytof)
library(dplyr)

## -----------------------------------------------------------------------------
data(phenograph_data)

# before preprocessing
phenograph_data %>%
    select(cd45, cd34, cd38) %>%
    head()

## -----------------------------------------------------------------------------
phenograph_data %>%
    # perform preprocessing
    tof_preprocess() %>%
    # inspect new values
    select(cd45, cd34, cd38) %>%
    head()

## -----------------------------------------------------------------------------
phenograph_data %>%
    # preprocess
    tof_preprocess(transform_fun = scale) %>%
    # inspect new values
    select(cd45, cd34, cd38) %>%
    head()

## -----------------------------------------------------------------------------
print(phenograph_data) %>%
    select(cd45, cd34, cd38) %>%
    head()

# after preprocessing and post-processing, the data are the same
# except that the re-added noise component is different for each value
phenograph_data %>%
    tof_preprocess() %>%
    tof_postprocess(redo_noise = TRUE) %>%
    select(cd45, cd34, cd38) %>%
    head()

## -----------------------------------------------------------------------------
sessionInfo()

