## --------------------------------------------------
## Create the data set davidTiling
## --------------------------------------------------

library("davidTiling")
library("affy")
options(error=recover)

celDir  = system.file("celfiles", package="davidTiling")
outDir  = "../../data"

pd = new("phenoData",
  pData = data.frame(
    filename = I(c("09_11_04_S96_genDNA_16hrs_45C_noDMSO.cel.gz",
      "041119_S96genDNA_re-hybe.cel.gz",
      "041120_S96genDNA_re-hybe.cel.gz",
      "05_04_27_2xpolyA_NAP3.cel.gz",
      "05_04_26_2xpolyA_NAP2.cel.gz",
      "05_04_20_2xpolyA_NAP_2to1.cel.gz",  ## "super-clean"
      "050409_totcDNA_14ug_no52.cel.gz",
      "030505_totcDNA_15ug_affy.cel.gz")),
    nucleicAcid = c(rep("genomic DNA", 3), rep("poly(A) RNA", 3), rep("total RNA", 2))),
  varLabels = list(filename="Name of the compressed CEL file, from Lior David",
            nucleicAcid="What is the sample? A factor with three levels: genomic DNA, poly(A) RNA, total RNA"))

##  varMetadata = data.frame(varNames=I(c("filename", "nucleicAcid")),
##    comment=I(c("Name of the compressed CEL file, from Lior David",
##                "What is the sample? A factor with three levels: genomic DNA, poly(A) RNA, total RNA")))

##
## read AffyBatch
##
ints = matrix(as.integer(NA), nrow=2560*2560, ncol=nrow(pData(pd)))
colnames(ints) = pd$filename
for(f in pd$filename) {
  a = read.affybatch(filenames=file.path(celDir, f), verbose=TRUE, compress=TRUE)
  ints[, f] = as.integer(intensity(a))
  rm(a); gc()
}

##
## create eSet
##
e = new.env()
assign("exprs", ints, e)
rm(ints); gc()
davidTiling = new("eSet", assayData=e, phenoData=pd, sampleNames=sub(".cel.gz", "", pd$filename))

##
## save eSet
##
save(davidTiling, file=file.path(outDir, "davidTiling.rda"), compress=TRUE)
