/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bridgedb.DataSource;

public final class DataSourcePatterns {
    private static Map<DataSource, Pattern> patterns = new HashMap<DataSource, Pattern>();

    private DataSourcePatterns() {
    }

    public static void registerPattern(DataSource key, Pattern value) {
        patterns.put(key, value);
    }

    public static Set<DataSource> getDataSourceMatches(String id) {
        HashSet<DataSource> result = new HashSet<DataSource>();
        for (DataSource ds : patterns.keySet()) {
            Matcher m = patterns.get(ds).matcher(id);
            if (!m.matches()) continue;
            result.add(ds);
        }
        return result;
    }

    public static Map<DataSource, Pattern> getPatterns() {
        return patterns;
    }
}

