## -----------------------------------------------------------------------------
library("LACE")
data(longitudinal_sc_variants)
names(longitudinal_sc_variants)

## -----------------------------------------------------------------------------
lik_weights = c(0.2308772,0.2554386,0.2701754,0.2435088)

## -----------------------------------------------------------------------------
alpha = list()
alpha[[1]] = c(0.02,0.01,0.01,0.01)
alpha[[2]] = c(0.10,0.05,0.05,0.05)
beta = list()
beta[[1]] = c(0.10,0.05,0.05,0.05)
beta[[2]] = c(0.10,0.05,0.05,0.05)
head(alpha)
head(beta)

## -----------------------------------------------------------------------------
inference = LACE(D = longitudinal_sc_variants, 
    lik_w = lik_weights, 
    alpha = alpha, 
    beta = beta, 
    keep_equivalent = TRUE, 
    num_rs = 5, 
    num_iter = 10, 
    n_try_bs = 5, 
    num_processes = NA, 
    seed = 12345, 
    verbose = FALSE)

## -----------------------------------------------------------------------------
data(inference)
print(names(inference))

## ----fig.width=12, fig.height=8, warning=FALSE, fig.cap="Inferred model"------
clone_labels = c("ARPC2","PRAME","HNRNPC","COL1A2","RPL5","CCT8")
longitudinal.tree = longitudinal.tree.plot(inference = inference, 
                                           labels_show = "clones", 
                                           clone_labels = clone_labels, 
                                           legend_position = "topright")

