###
###

.pkgname <- "BSgenome.HSapiens.QuasR.hg19sub"

.seqnames <- paste0('chr',1:3)

.circ_seqs <- NULL

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Homo Sapiens",
        common_name="Human",
        provider="QuasR",
        provider_version="hg19sub",
        release_date="Feb. 2009",
        release_name="Genome Reference Consortium GRCh37",
        source_url="-- information not available --",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "hg19sub"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

