/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.svg;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jfree.svg.util.Args;

public class StandardFontFunction
implements Function<String, String> {
    private final Map<String, String> alternates = new HashMap<String, String>();

    public StandardFontFunction() {
        this.alternates.put("Dialog", "sans-serif");
        this.alternates.put("DialogInput", "monospace");
        this.alternates.put("SansSerif", "sans-serif");
        this.alternates.put("Serif", "serif");
        this.alternates.put("Monospaced", "monospace");
    }

    public String get(String family) {
        Args.nullNotPermitted(family, "family");
        return this.alternates.get(family);
    }

    public void put(String family, String substitute) {
        Args.nullNotPermitted(family, "family");
        this.alternates.put(family, substitute);
    }

    @Override
    public String apply(String family) {
        Args.nullNotPermitted(family, "family");
        Object alternate = this.alternates.get(family);
        if (alternate == null) {
            alternate = "\"" + family + "\"";
        }
        return alternate;
    }
}

