/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier;

import java.util.ArrayList;
import java.util.List;

public class HierarchyTree {
    private String name;
    private String rank;
    private int taxid;
    private int leaveCount;
    private HierarchyTree parent;
    private List<HierarchyTree> subclasses = new ArrayList<HierarchyTree>();
    private int genusIndex = -1;
    private double copyNumber = 0.0;

    public HierarchyTree(String n, int taxid, String rank, int leaves, int gIndex, double copyNumber) {
        this.name = n;
        this.taxid = taxid;
        this.rank = rank;
        this.leaveCount = leaves;
        this.genusIndex = gIndex;
        this.copyNumber = copyNumber;
    }

    public HierarchyTree(String n, int taxid, String rank, int leaves, int gIndex) {
        this(n, taxid, rank, leaves, gIndex, 1.0);
    }

    public void addParent(HierarchyTree p) {
        this.parent = p;
        if (this.parent != null) {
            this.parent.addSubclass(this);
        }
    }

    private void addSubclass(HierarchyTree c) {
        this.subclasses.add(c);
    }

    public String getName() {
        return this.name;
    }

    public HierarchyTree getParent() {
        return this.parent;
    }

    public String getRank() {
        return this.rank;
    }

    public int getTaxid() {
        return this.taxid;
    }

    public List<HierarchyTree> getSubclasses() {
        return this.subclasses;
    }

    public int getSizeofSubclasses() {
        return this.subclasses.size();
    }

    public HierarchyTree getChild(String name) {
        for (HierarchyTree t : this.subclasses) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    public int getLeaveCount() {
        return this.leaveCount;
    }

    public int getGenusIndex() {
        return this.genusIndex;
    }

    public double getCopyNumber() {
        return this.copyNumber;
    }

    public boolean hasCopyNumberInfo() {
        return this.copyNumber > 0.0;
    }
}

