/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.comparison;

import edu.msu.cme.rdp.classifier.comparison.SeqInfo;
import edu.msu.cme.rdp.classifier.comparison.Taxon;

public class Score {
    private float score;
    private Taxon node;
    private Score nextSeqScore;
    private Score nextAssignScore;
    private SeqInfo seqInfo;

    public Score(float s, SeqInfo seq, Taxon n) {
        this.score = s;
        this.seqInfo = seq;
        this.seqInfo.addScore(this);
        this.node = n;
    }

    Taxon getTaxon() {
        return this.node;
    }

    SeqInfo getSeqInfo() {
        return this.seqInfo;
    }

    Score getNextSeqScore() {
        return this.nextSeqScore;
    }

    Score getNextAssignScore() {
        return this.nextAssignScore;
    }

    void setNextSeqScore(Score s) {
        this.nextSeqScore = s;
    }

    void setNextAssignScore(Score s) {
        if (this.nextAssignScore == null) {
            this.nextAssignScore = s;
            return;
        }
        this.nextAssignScore.setNextAssignScore(s);
    }

    public float getScore() {
        return this.score;
    }

    public String getName() {
        return this.node.getName();
    }

    public String getRank() {
        return this.node.getRank();
    }

    public int getTaxid() {
        return this.node.getTaxid();
    }
}

