/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.taxatree.utils;

import edu.msu.cme.rdp.taxatree.Taxon;
import edu.msu.cme.rdp.taxatree.VisitInfo;
import edu.msu.cme.rdp.taxatree.interfaces.TreeVisitor;
import java.io.PrintStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewickPrintVisitor<E extends Taxon>
implements TreeVisitor<E> {
    private PrintStream writer;
    private NewickDistanceFactory distFactory;
    private boolean printInnerNodeLabels;

    public NewickPrintVisitor(PrintStream writer) {
        this(writer, true, new NewickDistanceFactory(){

            public float getDistance(int taxid) {
                return 1.0f;
            }
        });
    }

    public NewickPrintVisitor(PrintStream writer, boolean innerNodeLabels) {
        this(writer, innerNodeLabels, new NewickDistanceFactory(){

            public float getDistance(int taxid) {
                return 1.0f;
            }
        });
    }

    public NewickPrintVisitor(PrintStream writer, boolean innerNodeLabels, NewickDistanceFactory factory) {
        this.writer = writer;
        this.distFactory = factory;
        this.printInnerNodeLabels = innerNodeLabels;
    }

    @Override
    public boolean visitNode(VisitInfo<E> visitInfo) {
        String indent = "";
        if (visitInfo.getVisitType() == VisitInfo.VisitType.down) {
            if (visitInfo.hasChildren()) {
                this.writer.print(indent + "(");
            }
        } else if (visitInfo.getVisitType() == VisitInfo.VisitType.up) {
            String paren = "";
            if (visitInfo.hasChildren()) {
                paren = ")";
            }
            String label = "";
            if ((this.printInnerNodeLabels || !visitInfo.hasChildren()) && (label = ((Taxon)visitInfo.getTaxon()).getName()).contains(" ")) {
                label = "\"" + label + "\"";
            }
            if (visitInfo.getDepth() > 0) {
                this.writer.print(indent + paren + label + ":" + this.distFactory.getDistance(((Taxon)visitInfo.getTaxon()).getTaxid()));
            } else {
                this.writer.print(indent + paren + label + ";");
            }
            if (!visitInfo.isLastChild()) {
                this.writer.print(",");
            }
        }
        return true;
    }

    public static interface NewickDistanceFactory {
        public float getDistance(int var1);
    }
}

