/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.readers.core;

import edu.msu.cme.rdp.readseq.SequenceFormat;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.core.SeqReaderCore;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.LinkedHashMap;
import java.util.Map;

public class FastaCore
extends SeqReaderCore {
    public FastaCore(File seqFile) throws IOException {
        super(seqFile);
        this.readUntilNext('>');
    }

    public FastaCore(InputStream is) throws IOException {
        super(is);
        this.readUntilNext('>');
    }

    @Override
    public Map<String, Long> scanInternal() throws IOException {
        RandomAccessFile seqFile = super.getRawFile();
        seqFile.seek(0L);
        this.readUntilNext('>');
        long firstHeader = seqFile.getFilePointer();
        long lastHeader = seqFile.getFilePointer();
        LinkedHashMap<String, Long> seqIndex = new LinkedHashMap<String, Long>();
        while (seqFile.getFilePointer() != seqFile.length()) {
            String sid = this.parseSid();
            seqIndex.put(sid, lastHeader);
            this.readUntilNext("\n>");
            lastHeader = seqFile.getFilePointer();
        }
        seqFile.seek(firstHeader);
        return seqIndex;
    }

    public int scanToStream(DataOutputStream out) throws IOException {
        RandomAccessFile seqFile = super.getRawFile();
        seqFile.seek(0L);
        this.readUntilNext('>');
        long firstHeader = seqFile.getFilePointer();
        long lastHeader = seqFile.getFilePointer();
        LinkedHashMap seqIndex = new LinkedHashMap();
        out.writeLong(seqFile.length());
        out.writeUTF(SequenceFormat.FASTA.toString());
        int written = 0;
        while (seqFile.getFilePointer() != seqFile.length()) {
            String sid = this.parseSid();
            out.writeUTF(sid);
            out.writeLong(lastHeader);
            ++written;
            this.readUntilNext("\n>");
            lastHeader = seqFile.getFilePointer();
        }
        out.close();
        seqFile.seek(firstHeader);
        return written;
    }

    @Override
    public Sequence readNextSeq() throws IOException {
        String header = this.parseHeader();
        if (header == null) {
            return null;
        }
        String seq = this.parseSeq();
        if (seq == null) {
            return null;
        }
        String seqid = header.split("\\s+")[0];
        header = seqid.length() == header.length() ? "" : header.substring(seqid.length()).trim();
        return new Sequence(seqid, header, seq.trim());
    }

    private String parseSid() throws IOException {
        return this.readUntilNext(' ', '\t', '\n', '\r');
    }

    private String parseHeader() throws IOException {
        return this.readUntilNext('\n');
    }

    private String parseSeq() throws IOException {
        return this.readUntilNext("\n>");
    }
}

