/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.alignment.hmm;

import edu.msu.cme.rdp.alignment.hmm.ProfileHMM;
import edu.msu.cme.rdp.alignment.hmm.TSC;

public class MostProbableHCostHMM {
    private ProfileHMM hmm;
    private static final char[] mapping = new char[]{'A', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'Y'};
    private final double[][] mostProbFromState;

    public MostProbableHCostHMM(ProfileHMM hmm) {
        this.hmm = hmm;
        this.mostProbFromState = new double[128][hmm.M() + 1];
        for (int index = 0; index <= hmm.M(); ++index) {
            this.mostProbFromState[109][index] = this.computeCostInternal('m', index);
            this.mostProbFromState[105][index] = this.computeCostInternal('i', index);
            this.mostProbFromState[100][index] = this.computeCostInternal('d', index);
        }
    }

    public double computeHeuristicCost(char state, int stateNo) {
        return this.mostProbFromState[state][stateNo];
    }

    private double computeCostInternal(char prevState, int stateNo) {
        double h = 0.0;
        double matchTrans = Double.NEGATIVE_INFINITY;
        double insTrans = Double.NEGATIVE_INFINITY;
        double delTrans = Double.NEGATIVE_INFINITY;
        double bestMatchProb = Double.NEGATIVE_INFINITY;
        double bestInsProb = Double.NEGATIVE_INFINITY;
        for (int state = stateNo + 1; state <= this.hmm.M(); ++state) {
            switch (prevState) {
                case 'm': {
                    matchTrans = this.hmm.tsc(state - 1, TSC.MM);
                    insTrans = this.hmm.tsc(state - 1, TSC.MI);
                    delTrans = this.hmm.tsc(state - 1, TSC.MD);
                    break;
                }
                case 'd': {
                    matchTrans = this.hmm.tsc(state - 1, TSC.DM);
                    insTrans = Double.NEGATIVE_INFINITY;
                    delTrans = this.hmm.tsc(state - 1, TSC.DD);
                    break;
                }
                case 'i': {
                    matchTrans = this.hmm.tsc(state - 1, TSC.IM);
                    insTrans = this.hmm.tsc(state - 1, TSC.II);
                    delTrans = Double.NEGATIVE_INFINITY;
                    break;
                }
                default: {
                    throw new RuntimeException("I hate you.");
                }
            }
            bestMatchProb = Double.NEGATIVE_INFINITY;
            bestInsProb = Double.NEGATIVE_INFINITY;
            for (int k = 0; k < this.hmm.K(); ++k) {
                if (this.hmm.msc(state, k) > bestMatchProb) {
                    bestMatchProb = this.hmm.msc(state, k);
                }
                if (!(this.hmm.isc(state, k) > bestInsProb)) continue;
                bestInsProb = this.hmm.isc(state, k);
            }
            matchTrans += bestMatchProb - this.hmm.getMaxMatchEmission(state);
            delTrans -= this.hmm.getMaxMatchEmission(state);
            insTrans += bestInsProb;
            insTrans = Double.NEGATIVE_INFINITY;
            if (insTrans > matchTrans && insTrans > delTrans) {
                h += insTrans;
                prevState = (char)105;
                --state;
                continue;
            }
            if (delTrans > matchTrans && delTrans > insTrans) {
                h += delTrans;
                prevState = (char)100;
                continue;
            }
            h += matchTrans;
            prevState = (char)109;
        }
        return h;
    }
}

