/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileReader;
import htsjdk.samtools.CRAMFileReader;
import htsjdk.samtools.CustomReaderFactory;
import htsjdk.samtools.DefaultSAMRecordFactory;
import htsjdk.samtools.Defaults;
import htsjdk.samtools.InputResource;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.SAMTextReader;
import htsjdk.samtools.SamFiles;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamStreams;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.zip.GZIPInputStream;

public abstract class SamReaderFactory {
    private static ValidationStringency defaultValidationStringency = ValidationStringency.DEFAULT_STRINGENCY;
    private static SamReaderFactoryImpl DEFAULT = new SamReaderFactoryImpl(Option.DEFAULTS, defaultValidationStringency, DefaultSAMRecordFactory.getInstance());

    public abstract SamReader open(File var1);

    public abstract SamReader open(SamInputResource var1);

    public abstract ValidationStringency validationStringency();

    public abstract ReferenceSource referenceSource();

    public abstract SamReaderFactory samRecordFactory(SAMRecordFactory var1);

    public abstract SamReaderFactory enable(Option ... var1);

    public abstract SamReaderFactory disable(Option ... var1);

    public abstract SamReaderFactory setOption(Option var1, boolean var2);

    public abstract SamReaderFactory referenceSequence(File var1);

    public abstract SamReaderFactory referenceSource(ReferenceSource var1);

    public abstract SAMFileHeader getFileHeader(File var1);

    public abstract void reapplyOptions(SamReader var1);

    public abstract SamReaderFactory validationStringency(ValidationStringency var1);

    public static void setDefaultValidationStringency(ValidationStringency defaultValidationStringency) {
        SamReaderFactory.defaultValidationStringency = defaultValidationStringency;
        DEFAULT = new SamReaderFactoryImpl(Option.DEFAULTS, defaultValidationStringency, DefaultSAMRecordFactory.getInstance());
    }

    public static SamReaderFactory makeDefault() {
        return SamReaderFactoryImpl.copyOf(DEFAULT);
    }

    public static SamReaderFactory make() {
        return new SamReaderFactoryImpl(EnumSet.noneOf(Option.class), ValidationStringency.DEFAULT_STRINGENCY, DefaultSAMRecordFactory.getInstance());
    }

    public static enum Option {
        INCLUDE_SOURCE_IN_RECORDS{

            @Override
            void applyTo(BAMFileReader underlyingReader, SamReader reader) {
                underlyingReader.enableFileSource(reader, true);
            }

            @Override
            void applyTo(SAMTextReader underlyingReader, SamReader reader) {
                underlyingReader.enableFileSource(reader, true);
            }

            @Override
            void applyTo(CRAMFileReader underlyingReader, SamReader reader) {
                underlyingReader.enableFileSource(reader, true);
            }
        }
        ,
        CACHE_FILE_BASED_INDEXES{

            @Override
            void applyTo(BAMFileReader underlyingReader, SamReader reader) {
                underlyingReader.enableIndexCaching(true);
            }

            @Override
            void applyTo(SAMTextReader underlyingReader, SamReader reader) {
                Option.logDebugIgnoringOption(reader, (Option)this);
            }

            @Override
            void applyTo(CRAMFileReader underlyingReader, SamReader reader) {
                underlyingReader.enableIndexCaching(true);
            }
        }
        ,
        DONT_MEMORY_MAP_INDEX{

            @Override
            void applyTo(BAMFileReader underlyingReader, SamReader reader) {
                underlyingReader.enableIndexMemoryMapping(false);
            }

            @Override
            void applyTo(SAMTextReader underlyingReader, SamReader reader) {
                Option.logDebugIgnoringOption(reader, (Option)this);
            }

            @Override
            void applyTo(CRAMFileReader underlyingReader, SamReader reader) {
                underlyingReader.enableIndexMemoryMapping(false);
            }
        }
        ,
        EAGERLY_DECODE{

            @Override
            void applyTo(BAMFileReader underlyingReader, SamReader reader) {
                underlyingReader.setEagerDecode(true);
            }

            @Override
            void applyTo(SAMTextReader underlyingReader, SamReader reader) {
                Option.logDebugIgnoringOption(reader, (Option)this);
            }

            @Override
            void applyTo(CRAMFileReader underlyingReader, SamReader reader) {
                Option.logDebugIgnoringOption(reader, (Option)this);
            }
        }
        ,
        VALIDATE_CRC_CHECKSUMS{

            @Override
            void applyTo(BAMFileReader underlyingReader, SamReader reader) {
                underlyingReader.enableCrcChecking(true);
            }

            @Override
            void applyTo(SAMTextReader underlyingReader, SamReader reader) {
                Option.logDebugIgnoringOption(reader, (Option)this);
            }

            @Override
            void applyTo(CRAMFileReader underlyingReader, SamReader reader) {
                Option.logDebugIgnoringOption(reader, (Option)this);
            }
        };

        public static EnumSet<Option> DEFAULTS;
        private static final Log LOG;

        void applyTo(SamReader.PrimitiveSamReaderToSamReaderAdapter reader) {
            SamReader.PrimitiveSamReader underlyingReader = reader.underlyingReader();
            if (underlyingReader instanceof BAMFileReader) {
                this.applyTo((BAMFileReader)underlyingReader, (SamReader)reader);
            } else if (underlyingReader instanceof SAMTextReader) {
                this.applyTo((SAMTextReader)underlyingReader, (SamReader)reader);
            } else if (underlyingReader instanceof CRAMFileReader) {
                this.applyTo((CRAMFileReader)underlyingReader, (SamReader)reader);
            } else {
                throw new IllegalArgumentException(String.format("Unrecognized reader type: %s.", underlyingReader.getClass()));
            }
        }

        private static void logDebugIgnoringOption(SamReader r, Option option) {
            LOG.debug(String.format("Ignoring %s option; does not apply to %s readers.", new Object[]{option, r.getClass().getSimpleName()}));
        }

        abstract void applyTo(BAMFileReader var1, SamReader var2);

        abstract void applyTo(SAMTextReader var1, SamReader var2);

        abstract void applyTo(CRAMFileReader var1, SamReader var2);

        static {
            DEFAULTS = EnumSet.noneOf(Option.class);
            LOG = Log.getInstance(Option.class);
        }
    }

    private static class SamReaderFactoryImpl
    extends SamReaderFactory {
        private static final Log LOG = Log.getInstance(SamReaderFactory.class);
        private final EnumSet<Option> enabledOptions;
        private ValidationStringency validationStringency;
        private SAMRecordFactory samRecordFactory;
        private CustomReaderFactory customReaderFactory;
        private ReferenceSource referenceSource;

        private SamReaderFactoryImpl(EnumSet<Option> enabledOptions, ValidationStringency validationStringency, SAMRecordFactory samRecordFactory) {
            this.enabledOptions = EnumSet.copyOf(enabledOptions);
            this.samRecordFactory = samRecordFactory;
            this.validationStringency = validationStringency;
            this.customReaderFactory = CustomReaderFactory.getInstance();
        }

        @Override
        public SamReader open(File file) {
            SamInputResource r = SamInputResource.of(file);
            File indexMaybe = SamFiles.findIndex(file);
            if (indexMaybe != null) {
                r.index(indexMaybe);
            }
            return this.open(r);
        }

        @Override
        public ValidationStringency validationStringency() {
            return this.validationStringency;
        }

        @Override
        public ReferenceSource referenceSource() {
            return this.referenceSource;
        }

        @Override
        public SamReaderFactory samRecordFactory(SAMRecordFactory samRecordFactory) {
            this.samRecordFactory = samRecordFactory;
            return this;
        }

        @Override
        public SamReaderFactory enable(Option ... options) {
            Collections.addAll(this.enabledOptions, options);
            return this;
        }

        @Override
        public SamReaderFactory disable(Option ... options) {
            for (Option option : options) {
                this.enabledOptions.remove((Object)option);
            }
            return this;
        }

        @Override
        public SamReaderFactory setOption(Option option, boolean value) {
            if (value) {
                return this.enable(option);
            }
            return this.disable(option);
        }

        @Override
        public SamReaderFactory referenceSequence(File referenceSequence) {
            this.referenceSource = new ReferenceSource(referenceSequence);
            return this;
        }

        @Override
        public SamReaderFactory referenceSource(ReferenceSource referenceSource) {
            this.referenceSource = referenceSource;
            return this;
        }

        @Override
        public SAMFileHeader getFileHeader(File samFile) {
            SamReader reader = this.open(samFile);
            SAMFileHeader header = reader.getFileHeader();
            CloserUtil.close(reader);
            return header;
        }

        @Override
        public void reapplyOptions(SamReader reader) {
            for (Option option : this.enabledOptions) {
                option.applyTo((SamReader.PrimitiveSamReaderToSamReaderAdapter)reader);
            }
        }

        @Override
        public SamReaderFactory validationStringency(ValidationStringency validationStringency) {
            this.validationStringency = validationStringency;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public SamReader open(SamInputResource resource) {
            try {
                void var2_16;
                SamReader reader;
                InputResource data = resource.data();
                InputResource indexMaybe = resource.indexMaybe();
                boolean indexDefined = indexMaybe != null;
                InputResource.Type type = data.type();
                if (type == InputResource.Type.URL && (reader = this.customReaderFactory.maybeOpen(data.asUrl())) != null) {
                    return reader;
                }
                if (type == InputResource.Type.SEEKABLE_STREAM || type == InputResource.Type.URL) {
                    if (!SamStreams.sourceLikeBam(data.asUnbufferedSeekableStream())) throw new SAMFormatException("Unrecognized file format: " + data.asUnbufferedSeekableStream());
                    SeekableStream bufferedIndexStream = indexDefined && indexMaybe.asUnbufferedSeekableStream() != null ? IOUtil.maybeBufferedSeekableStream(indexMaybe.asUnbufferedSeekableStream()) : null;
                    BAMFileReader bAMFileReader = new BAMFileReader(IOUtil.maybeBufferedSeekableStream(data.asUnbufferedSeekableStream()), bufferedIndexStream, false, this.validationStringency, this.samRecordFactory);
                } else {
                    File indexFile;
                    InputStream bufferedStream = IOUtil.maybeBufferInputStream(data.asUnbufferedInputStream(), Math.max(Defaults.BUFFER_SIZE, 65536));
                    File sourceFile = data.asFile();
                    File file = indexFile = indexMaybe == null ? null : indexMaybe.asFile();
                    if (SamStreams.isBAMFile(bufferedStream)) {
                        if (sourceFile == null || !sourceFile.isFile()) {
                            BAMFileReader bAMFileReader = new BAMFileReader(bufferedStream, indexFile, false, this.validationStringency, this.samRecordFactory);
                        } else {
                            bufferedStream.close();
                            BAMFileReader bAMFileReader = new BAMFileReader(sourceFile, indexFile, false, this.validationStringency, this.samRecordFactory);
                        }
                    } else if (BlockCompressedInputStream.isValidFile(bufferedStream)) {
                        SAMTextReader sAMTextReader = new SAMTextReader(new BlockCompressedInputStream(bufferedStream), this.validationStringency, this.samRecordFactory);
                    } else if (SamStreams.isGzippedSAMFile(bufferedStream)) {
                        SAMTextReader sAMTextReader = new SAMTextReader(new GZIPInputStream(bufferedStream), this.validationStringency, this.samRecordFactory);
                    } else if (SamStreams.isCRAMFile(bufferedStream)) {
                        if (sourceFile == null || !sourceFile.isFile()) {
                            sourceFile = null;
                        } else {
                            bufferedStream.close();
                            bufferedStream = null;
                        }
                        if (this.referenceSource != null) {
                            CRAMFileReader cRAMFileReader = new CRAMFileReader(sourceFile, bufferedStream, this.referenceSource);
                        } else {
                            CRAMFileReader cRAMFileReader = new CRAMFileReader(sourceFile, bufferedStream);
                        }
                    } else {
                        if (indexDefined) {
                            bufferedStream.close();
                            throw new RuntimeException("Cannot use index file with textual SAM file");
                        }
                        SAMTextReader sAMTextReader = new SAMTextReader(bufferedStream, sourceFile, this.validationStringency, this.samRecordFactory);
                    }
                }
                reader = new SamReader.PrimitiveSamReaderToSamReaderAdapter((SamReader.PrimitiveSamReader)var2_16, resource);
                for (Option option : this.enabledOptions) {
                    option.applyTo((SamReader.PrimitiveSamReaderToSamReaderAdapter)reader);
                }
                return reader;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }

        public static SamReaderFactory copyOf(SamReaderFactoryImpl target) {
            return new SamReaderFactoryImpl(target.enabledOptions, target.validationStringency, target.samRecordFactory);
        }
    }
}

