## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, message=FALSE, results="hide"-------------------------------------
library(shiny.gosling)
library(shiny)
library(sessioninfo)

## ----store-data-links---------------------------------------------------------

cistrome_data <- "https://server.gosling-lang.org/api/v1/tileset_info/?d=cistrome-multivec"

## ----setup-track--------------------------------------------------------------
single_track <- add_single_track(
  id = "track1",
  data = track_data(
    url = cistrome_data,
    type = "multivec",
    row = "sample",
    column = "position",
    value = "peak",
    categories = c("sample 1", "sample 2", "sample 3", "sample 4"),
    binSize = 4,
  ),
  mark = "rect",
  x = visual_channel_x(field = "start", type = "genomic", axis = "top"),
  xe = visual_channel_x(field = "end", type = "genomic"),
  row = visual_channel_row(
    field = "sample",
    type = "nominal",
    legend = TRUE
  ),
  color = visual_channel_color(
    field = "peak",
    type = "quantitative",
    legend = TRUE
  ),
  tooltip = visual_channel_tooltips(
    visual_channel_tooltip(field = "start", type = "genomic", alt = "Start Position"),
    visual_channel_tooltip(field = "end", type = "genomic", alt = "End Position"),
    visual_channel_tooltip(
      field = "peak",
      type = "quantitative",
      alt = "Value",
      format = "0.2"
    )
  ),
  width = 600,
  height = 130
)


## ----compose-track, results="hide"--------------------------------------------
single_composed_track <- compose_view(
  tracks = single_track
)

## ----final-view---------------------------------------------------------------
single_composed_views <- arrange_views(
  title = "Single Track",
  subtitle = "This is the simplest single track visualization with a linear layout",
  layout = "circular",
  views = single_composed_track,
  xDomain = list(
    chromosome = "chr1",
    interval = c(1, 3000500)
  )
)


## ----run-app, results="hide"--------------------------------------------------

server <- function(input, output, session) {

  output$gosling_plot <- renderGosling({
    gosling(
      component_id = "component_1",
      single_composed_views,
      clean_braces = TRUE
    )
  })
}

ui <- fluidPage(
  use_gosling(),
  goslingOutput("gosling_plot")
)


shiny::shinyApp(ui, server, options = list(height = 700))

## ----session_info-------------------------------------------------------------

sessionInfo()

