## ----setup, include = FALSE---------------------------------------------------
library(DNAcycP2)
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)

## ----eval = FALSE-------------------------------------------------------------
# if (!require("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# BiocManager::install("DNAcycP2")

## -----------------------------------------------------------------------------
library(DNAcycP2)

## -----------------------------------------------------------------------------
ex1_file <- system.file("extdata", "ex1.fasta", package = "DNAcycP2")
ex1_smooth <- DNAcycP2::cycle_fasta(
    ex1_file, smooth=TRUE, n_cores=1, chunk_length=1000
)
ex1_original <- DNAcycP2::cycle_fasta(
    ex1_file, smooth=FALSE, n_cores=1, chunk_length=1000
)

## -----------------------------------------------------------------------------
ex2_file <- system.file("extdata", "ex2.txt", package = "DNAcycP2")
ex2 <- read.csv(ex2_file, header = FALSE)
ex2_smooth <- DNAcycP2::cycle(ex2$V1, smooth=TRUE)
ex2_original <- DNAcycP2::cycle(ex2$V1, smooth=FALSE)

## ----eval=FALSE---------------------------------------------------------------
# ex2_smooth <- DNAcycP2::cycle(
#     ex2$V1,
#     smooth=TRUE,
#     save_path_prefix="ex2_smooth"
# )

## -----------------------------------------------------------------------------
ex3_fasta_file <- system.file(
    "extdata", "ex3_single_seq.fasta", package = "DNAcycP2"
)
ex3_fasta_smooth <- DNAcycP2::cycle_fasta(ex3_fasta_file,smooth=TRUE)
ex3_fasta_original <- DNAcycP2::cycle_fasta(ex3_fasta_file,smooth=FALSE)

## -----------------------------------------------------------------------------
ex3_fasta_smooth[[1]][1:51,c("position", "C0S_norm")]

## -----------------------------------------------------------------------------
ex3_fasta_smooth$cycle_1[1:51,c("position", "C0S_norm")]

## -----------------------------------------------------------------------------
ex3_txt_file <- system.file(
    "extdata", 
    "ex3_single_seq.txt", 
    package = "DNAcycP2"
)
ex3_txt <- read.csv(ex3_txt_file, header = FALSE)
ex3_txt_smooth <- DNAcycP2::cycle(ex3_txt$V1, smooth=TRUE)
ex3_txt_original <- DNAcycP2::cycle(ex3_txt$V1, smooth=FALSE)

## -----------------------------------------------------------------------------
library(Biostrings)
ex4_string_set <- readDNAStringSet(system.file("extdata", "ex1.fasta", package="DNAcycP2"))
ex4_smooth_output <- DNAcycP2::cycle(ex4_string_set, smooth=TRUE)

## ----sessionInfo--------------------------------------------------------------
sessionInfo()

